model Ex13_3
  //1 - 10% solution, 2 -  50% solution
  Real F(unit = "lb") "mass of solution", xF "fraction of NaoH in final solution", HF(unit = "Btu") "enthalpy of final solution", hf(unit = "Btu/lb") "enthalpy of final solution per lb", v(unit = "lb") "ammount of water vaporised";
  parameter Real m[2] = {600, 400}, x[2] = {0.1, 0.5}, delH[2] = {152, 290}, Hv = 1158, Hl = 175;
equation
  F = m[1] + m[2];
  F * xF = sum(m .* x);
  HF = sum(delH .* m);
  hf = HF / F;
  v * Hv + (F - v) * Hl = F * hf;
end Ex13_3;
