model Ex14_2
  Real V1(unit = "m^3") "initial volume", V2(unit = "m^3") "final volume", W(unit = "J") "work done";
  parameter Real T(unit = "K") = 293 "temperature", P(unit = "pa") = 1000 * 10 ^ 3 "Pressure", Patm(unit = "Pa") = 101325 "atmospheric pressure";
  constant Real R(unit = "Pa.m^3/K.kgmol") = 8314;
equation
  V1 = R * T / P;
  V2 = 2 * V1;
  W = Patm * (V2 - V1);
end Ex14_2;
