model Ex2_13
  Real xNa "mole fraction of NaOH", xWat "mole fraction of Water", wfNa "wight fraction of NaOH", wfWat "weight fraction of Water";
  parameter Real WNa(unit = "kg") = 5 "mass of NaOH", WWat(unit = "kg") = 5 "mass of Water";
  constant Real MNa = 18 "molecular weight of NaOH", MWat = 40 "molecular weight of Water";
equation
  wfNa = WNa / (WNa + WWat);
  wfWat = WWat / (WNa + WWat);
  xNa = WNa / MNa / (WNa / MNa + WWat / MWat);
  xWat = WWat / MWat / (WNa / MNa + WWat / MWat);
end Ex2_13;