model Ex2_19
  Real M(unit = "g") "mass of (NH4)2SO4";
  parameter Real Cf(unit = "g/L") = 35 "final concentration of cell", V(unit = "L") = 500, xN = 0.09 "weight fraction of nitrogen in cell", nN = 2 "no of N atoms in (NH4)2SO4 molecule";
  constant Real Mas = 132 "molecular weight of (NH4)2SO4", MN = 14 "molecular weight of Nitrogen";
equation
  M = V * Cf * xN * Mas / (MN * nN);
end Ex2_19;