model Ex3_4
  Real D(unit = "g") "Cell free discharge", P(unit = "g") "concentrated cells";
  parameter Real F(unit = "L/hr") = 1000, xP = 0.5 "fraction of cells in product stream", Fc(unit = "mg/L") = 500 "mass of cells in feed", Fd(unit = "g/cm^3") = 1 "Feed density";
equation
  F * Fc / 1000 = xP * P;
//cell balance
  F * Fd * 1000 = 0.5 * P + D;
//fluid balance
end Ex3_4;