package Ex5_3
  model basis
    Real mCC(unit = "lb") "mass of CaCO3", mMC(unit = "lb") "mass of MgCO3", mUn(unit = "lb") "mass of Unreactive";
    parameter Real xCC = 0.9289 "fraction of CaCO3", xMC = 0.0541 "fraction of MgCO3", xUn = 0.0170 "fraction of unreactive", mLS(unit = "lb") = 100 "mass of LimeStone";
  equation
    mCC = xCC * mLS;
    mMC = xMC * mLS;
    mUn = xUn * mLS;
  end basis;

  model a
    extends basis;
    Real mCO(unit = "lb") "mass of CaO";
    parameter Real mwCC = 100.1 "molecular weight of Calcium Carbonate", mwCO = 56.08 "molecular weight of Calcium Oxide";
  equation
    mCO = mCC * (mwCO / mwCC) * (1000 * 2 / 100);
  end a;

  model b
    extends basis;
    Real mCO2(unit = "lb") "mass of CO2 recovered";
    parameter Real mwCC = 100.1 "molecular weight of CaCO3", mwMC = 844.31 "molecular weight of MgCO3", mwCO2 = 44 "molecular weight of CO2";
  equation
    mCO2 = (mMC * (mwCO2 / mwMC) + mCC * (mwCO2 / mwCC)) * (1 / 100);
  end b;

  model c
    extends basis;
    Real mrLS(unit = "lb") "mass of required limestone";
    parameter Real mL(unit = "kg") = 1000 "Lime produced", mwCC = 100.1 "molecular weight of CaCO3", mwMC = 84.32 "molecular weight of MgCO3", mwCO = 56.08 "molecular weight of Calcium Oxide", mwMO = 40.32 "molecular weight of Magnessium Oxide";
  equation
    mL = (mrLS * xCC * (mwCO / mwCC) + mrLS * xMC * (mwMO / mwMC) + mrLS * xUn) / 2;
//mUn also considered as lime in book
  end c;
end Ex5_3;