model Ex5_6
  // assume A - Cl2, B - C3H6, C - C3H5Cl, D -C3H6Cl2, E - HCl
  Real mAi "initial gmol of A", mBi "initial gmol of B", xBC "fractional conversion B to C", sCD "selectivity of C relative to D", yBC "yeild of C", x1 "extent of reaction 1", x2 "extent of reaction 2";
  parameter Real mwA = 71, mwB = 42.08, mwC = 76.53, mwD = 112.99, mwE = 36.5, mAf(unit = "gmol") = 141 "gmol of A in product", mBf(unit = "gmol") = 651 "gmol of B in product", mCf(unit = "gmol") = 4.6 "gmol of C in product", mDf(unit = "gmol") = 24.5 "gmol of D in product", mEf(unit = "gmol") = 4.6 "gmol of E in product";
equation
  mAi = mAf + mCf + mDf;
  mBi = mBf + mCf + mDf;
  xBC = (mCf + mDf) / mBi;
  sCD = mCf / mDf;
  yBC = mCf * mwC / (mBi * mwB);
  x1 = (mCf - 0) / 1;
//initial C is 0
  x2 = (mDf - 0) / 1;
//initial D is 0
end Ex5_6;
