model Ex5_8
  // Let A - CH3OH, B - O2, C - N2, D - CH2O, E - H2O, F - CO
  // i are initial moles, f are final moles. x is conversion and y is yeild
  Real nAf, nBf, nCf, nDf, nEf, nFf, nBi, nCi;
  parameter Real nAi = 1, nDi = 0, nEi = 0, nFi = 0, xBair = 0.21, xCair = 0.79, xA = 0.9, yD = 0.75;
equation
  nBi = 2 * 0.5 * nAi;
//given in question
  nCi = nBi / xBair * xCair;
  nAf = (1 - xA) * nAi;
  nCf = nCi;
  nDf = yD * nAi;
  nBf = nBi - (0.5 * nDf + 1 * nFf);
  nEf = nDf + 2 * nFf;
  nFf = (xA - yD) * nAi;
end Ex5_8;
