model Ex5_9
  // Let A - glucose, B - ethanol, c - propenoic acid,  D - CO2, E - Water
  // i and f are for initial and final masses, pC and pB are final mass percent, mw - molecular weight
  Real pB, pC, mAi, mEi, mBf, mCf, mEf;
  parameter Real mTi = 4000, xAi = 0.12, mAf = 90, mDf = 120, mwA = 180.1, mwB = 46.05, mwC = 72.03, mwD = 44, mwE = 18.01;
equation
  mAi = xAi * mTi;
  mEi = (1 - xAi) * mTi;
  mBf = mwB / mwD * mCf;
  mCf = mwC / mwE * (mEf - mEi);
  mEf = mEi + (mAi - mwA / (2 * mwD) * mDf - mAf) * (2 * mwE / mwA);
  pB = mBf * 100 / (mAf + mBf + mCf + mDf + mEf);
  pC = mCf * 100 / (mAf + mBf + mCf + mDf + mEf);
end Ex5_9;
