model Ex6_2
  //x are Mass fractions
  //1 - Air, 2 - Acetone, 3 - Water
  //A,B,D,F,G, W are mass flow rates of respective streams
  
  Real A(unit = "kg/hr"), F(unit = "kg/hr"), W(unit = "kg/hr"), D(unit = "kg/hr"), B(unit = "kg/hr");
  parameter Real G(unit = "kg/hr") = 1400, xG[3] = {0.95, 0.03, 0.02}, xW[3] = {0, 0, 1}, xA[3] = {0.995, 0, 0.005}, xF[3] = {0, 0.19, 0.81}, xB[3] = {0, 0.04, 0.96}, xD[3] = {0, 0.99, 0.01};
equation
  xG .* G + xW .* W = xF .* F + xA .* A;
  xF[2] * F = xB[2] * B + xD[2] * D;
  xF[3] * F = xB[3] * B + xD[3] * D;
end Ex6_2;
