package Ex6_5
  model a
  //W, R, G, P, F are mass flow rates of respective streams
  //x are mass fractions
    Real W(unit = "lb/hr"), R(unit = "lb/hr"), G(unit = "lb/hr"), P(unit = "lb/hr");
    parameter Real F(unit = "lb/hr") = 10000, xF = 0.4, xW = 0, xG = 0.5, xR = 0.45, xP = 0.95, xPs = 0.45;
  equation
    F * xF + R * xR = W * xW + G * xG;
    F * (1 - xF) + R * (1 - xR) = W * (1 - xW) + G * (1 - xG);
    G * xG = R * xR + P * xP + P * (1 - xP) * xPs;
    G * (1 - xG) = R * (1 - xR) + P * (1 - xP) * (1 - xPs);
  end a;

  model b
  // F, W, R, G are mass flow rates of respective streams
  // x is mass fraction
    Real F(unit = "lb/hr"), W(unit = "lb/hr"), R(unit = "lb/hr"), G(unit = "lb/hr");
    parameter Real xF = 0.4, xW = 0, xG = 0.5, xR = 0.45, xP = 0.95, xPs = 0.45, P(unit = "lb/hr") = 4113.11;
  equation
    F * xF = W * xW + G * xG;
    F * (1 - xF) = W * (1 - xW) + G * (1 - xG);
    G * xG = R * xR + P * xP + P * (1 - xP) * xPs;
    G = P + R;
  end b;
end Ex6_5;
