model Ex6_9
  // a - H2, b - CO, c - CH4
  // prefix x shows fraction
  // E, P, R, F are moles of respective streams
  Real E(unit = "mol"), P(unit = "mol"), R(unit = "mol"), xRa, xRb;
  parameter Real F(unit = "mol") = 100, xFa = 0.673, xFb = 0.325, xFc = 0.002, xRc = 0.032, x = 0.18 "reactor per pass conversion of CO";
equation
  xFc * F = xRc * P;
  E = x * (xFb * F + xRb * R);
  xFb * F = E + xRb * P;
  xFa * F = 2 * E + xRa * P;
  xRa + xRb + xRc = 1;
end Ex6_9;
