model Ex7_3
  Real pCO2(unit = "mm Hg") "partial pressure of CO2", pO2(unit = "mm Hg") "partial pressure of O2", pN2(unit = "mm Hg") "partial pressure of N2";
  parameter Real P(unit = "mm Hg") = 765 "Total pressure", xCO2 = 0.14 "CO2 mole fraction", xO2 = 0.06 "O2 mole fraction", xN2 = 0.8 "N2 mole fraction";
equation
  pCO2 = P * xCO2;
  pO2 = P * xO2;
  pN2 = P * xN2;
end Ex7_3;
