model Ex7_8
  Real Vri "Reduced volume", Vci(unit = "m^3/kg mol"), spV(unit = "m^3 / kgmol"), Tr "reduced Temperature", Pr "Reduced Pressure", P(unit = "kPa") "Pressure";
  parameter Real Pc(unit = "kPa") = 5035 "Critical Pressure", Tc(unit = "K") = 154.4 "Critical Temperature", V(unit = "m^3") = 0.0284 "Volume", M(unit = "kg") = 3.5, mw = 32 "molecular weight of O2", T(unit = "K") = 248 "Temperature";
  constant Real R = 8.313;
equation
  spV = V / M * mw;
  Vci = R * Tc / Pc;
  Vri = spV / Vci;
  Tr = T / Tc;
  Pr = 1.43;
//taken from obert chart 7.8b
  P = Pr * Pc;
end Ex7_8;
