model Ex7_9
  //1 - CH4, 2 - C2H4, 3 - N2
  Real Va(unit = "cm^3/gmol"), Vb(unit = "cm^3/gmol"), pc(unit = "atm") "pseudocritical pressure", pr(unit = "atm") "pseudoreduced pressure", tc(unit = "K") "pseudocritical temperature", Tr(unit = "K") "pseudoreduced Temperature";
  parameter Real x[3] = {0.2, 0.3, 0.5} "mole fractions", P(unit = "atm") = 90 "Pressure", R(unit = "cm^3 * atm/gmol /K") = 82.06 "Gas constant", Tc[3] = {191, 283, 126} "Critical temperature", Pc[3] = {45.8, 50.5, 33.5} "Citical pressure", z = 0.95 "Compressibility factor", T(unit = "K") = 373 "Temperature";
equation
  Va = R * T / P;
  pc = sum(x .* Pc);
  tc = sum(x .* Tc);
  pr = P / pc;
  Tr = T / tc;
  Vb = z * R * T / P;
end Ex7_9;
