model Ex8_5
  Real nCO2 "CO2 moles in product", nCO "CO moles in product", nAO2 "O2 moles in air", nAN2 "N2 moles in air", nPO2 "O2 moles in product", nPN2 "N2 moles in product", nH2O "H2O moles in product", nP "Product moles", yH2O "H2O mole fraction in product", pH2O(unit = "kPa") "partial pressure of H2O";
  Real F = 1 "Basis", xAO2 = 0.21 "O2 mole fraction in air", xAN2 = 0.79 "N2 mole fraction in air", P(unit = "kPa") = 101.3 "Total pressure";
equation
  nAO2 = F * 0.5 * (1 + 0.04);
  nAN2 = nAO2 * (xAN2 / xAO2);
  nCO = 0.65 * 2 * F;
  2 * F = nCO2 + nCO;
  2 * F = 2 * nH2O;
  nAN2 = nPN2;
  4 * F + nAO2 = 2 * nCO2 + nCO + nPO2;
  nP = nCO2 + nCO + nPO2 + nPN2 + nH2O;
  yH2O = nH2O / nP;
  pH2O = yH2O * P;
//from partial pressure of H2O we can calculate dew point from steam table
end Ex8_5;
