model Ex9_1
  Real Q[2](each unit = "Btu/hr"), U[2](each unit = "Btu/ht/ft^2/F"), A[2](each unit = "ft^2"), delT[2](each unit = "F"), m "ratio of Q", s "saving per month";
  parameter Real Ti(unit = "F") = 75 "inside temperature", To(unit = "F") = 25 "outside temperature", w[2](each unit = "ft") = {3, 2}, h[2](each unit = "ft") = {5, 3}, p(unit = "$/Btu") = 9.5e-6 "Energy price";
equation
  Q[2] = U[2] * A[2] * delT[2];
  Q[1] = U[1] * A[1] * delT[1];
  delT[1] = Ti - To;
  delT[1] = delT[2];
  U[1] = 5.5;
  U[1] = U[2];
  m = Q[2] / Q[1];
  A[:] = w[:] .* h[:];
  s = U[1] * A[1] * delT[1] * p * 24 * 30 * (1 - m);
end Ex9_1;
