model Ex9_17
  Real delUb(unit = "kJ/kg") "sp. energy change of biomass", ms(unit = "kg/hr") "mass of steam per hour";
  parameter Real Ls(unit = "kJ/hr") = 1.5 "loss of heat to surrounding", delhs(unit = "kJ/kg") = -1701 "latent heat of vaporisation", Cpb(unit = "kJ/kg.C") = 3.26 "specific heat of biomass", T1b(unit = "C") = 20 "initial temperature of biomass", T2b(unit = "C") = 45 "final temperature of biomass", mb(unit = "kg/hr") = 150 "mass of biomass per hour";
equation
  delUb = Cpb * (T2b - T1b);
  mb * delUb = (-Ls * 3600) - ms * delhs;
end Ex9_17;
