model Ex9_3
  Real r(unit = "cm") "radius of tank", v(unit = "m/s") "water velocity", m(unit = "kg/s") "water mass flow rate", KE(unit = "J /Kg") "kinetic energy of water";
  parameter Real d(unit = "cm") = 3 "diameter", vfr(unit = "m^3") = 0.001 "volumetric flow rate", den(unit = "kg/m^3") = 1000 "water density";
  constant Real pi = 3.14;
equation
  r = 0.5 * d;
  m = den * vfr;
  v = vfr / (pi * r ^ 2 * 10 ^ (-4));
  KE = 0.5 * m * v ^ 2;
end Ex9_3;
