model Ex9_8
  Real H(unit = "kJ / gmol")"Heat of Vaporization";
  parameter Real Tb(unit = "K") = 329.2 "Boiling point", Tc(unit = "K") = 508 "Criticla Temperature", Pc(unit = "atm") = 47 "Critical pressure";
  constant Real R(unit = "kJ / gmol.K") = 0.008314;
equation
  H = R * Tb * (3.978 * (Tb / Tc) - 3.938 + 1.555 * log(Pc)) / (1.07 - Tb / Tc);
end Ex9_8;
