model Ex10_1

  Real X2d1 (final unit= "per unit") "Subtransient reactance of generator 1";
  Real X2d2 (final unit= "per unit") "Subtransient reactance of generator 2";
  Real Eg1 (final unit= "per unit") "rms voltage of generator 1";
  Real Eg2 (final unit= "per unit") "rms voltage of generator 2";
  Real X2d_eq (final unit= "per unit") "equivalent reactance of the two parallel transformer";
  Complex Isc "subtransient current in short circuit (pu)";
  Complex V_delta "voltage on delta side of the transformer(pu)";
  Complex I1_pu  "subtransient current of generator 1(pu)";
  Complex I2_pu  "subtransient current of generator 2(pu)";
  Real I1_pu_abs (final unit= "per unit") "magnitude of I1_pu";
  Real I2_pu_abs (final unit= "per unit") "magnitude of I2_pu";
  Modelica.SIunits.Current I1 "subtransient current of generator 1";
  Modelica.SIunits.Current I2 "subtransient current of generator 2";

  parameter OpenIPSL.Types.ApparentPowerMega S1= 50 "rating of generator 1";
  parameter OpenIPSL.Types.ApparentPowerMega S2= 25 "rating of generator 2";
  parameter OpenIPSL.Types.VoltageKilo V= 13.8 "voltage rating of generator 1 & 2";
  parameter Complex X2d= Complex(0, 0.25) "reactance of generator 1 & 2";
  parameter OpenIPSL.Types.ApparentPowerMega St= 75 "rating of transformer";
  parameter OpenIPSL.Types.VoltageKilo V_lt= 13.8 "voltage rating on L-T side of transformer(KV)";
  parameter OpenIPSL.Types.VoltageKilo V_ht= 69"voltage rating on H-T side of transformer(KV)";
  parameter OpenIPSL.Types.VoltageKilo V_bfault= 66 "voltage rating on H-T side of transformer before fault";
  parameter Complex Xt= Complex(0, 0.1) "transformer reactance";
  parameter OpenIPSL.Types.VoltageKilo Vb_ht= 69 "base voltage on H-T circuit";
  parameter OpenIPSL.Types.ApparentPowerMega Sb= St "base power";
  parameter OpenIPSL.Types.VoltageKilo Vb_lt= V_lt "base voltage on L-T circuit";
  
equation
  X2d1= X2d.im*((Sb*1e3)/(S1*1e3));
  X2d2= X2d.im*((Sb*1e3)/(S2*1e3));
  Eg1= V_bfault/Vb_ht;
  Eg2= Eg1;
  X2d_eq= (X2d1*X2d2)/(X2d1+X2d2);
  Isc= Eg1/(X2d+Xt);
  V_delta= Isc*Xt;
  I1_pu= (Eg1-V_delta)/Complex(0, X2d1);
  I2_pu= (Eg2-V_delta)/Complex(0, X2d2);
  I1_pu_abs= sqrt(I1_pu.re ^ 2 + I1_pu.im ^ 2);
  I2_pu_abs= sqrt(I2_pu.re ^ 2 + I2_pu.im ^ 2);
  I1= (I1_pu_abs*(Sb*1e3))/(Vb_lt*sqrt(3));
  I2= (I2_pu_abs*(Sb*1e3))/(Vb_lt*sqrt(3));
   
//"The  answer may slightly vary due to  rounding off values" 

end Ex10_1;
