model Ex10_2

  Real Vf (final unit= "per unit") "fault voltage(pu)";
  Modelica.SIunits.Current Ib "Base current";
  Modelica.SIunits.Current Il "line current";
  Complex Il_pu "per unit value of Il";
  Modelica.SIunits.Angle Il_arg "argument of Il";
  Real Il_pu_abs (final unit= "per unit") "magnitude of Il";
  //for generator
  Complex Vt_gen "terminal voltage of generator(pu)";
  Complex Egen "voltage across generator(pu)";
  Complex Igen_pu "per unit current across generator(pu)";
  Modelica.SIunits.ComplexCurrent Igen "Current across generator";
  //for motor
  Real Vter (final unit= "per unit") "terminal voltage of motor(pu)";
  Complex Emot "voltage across motor(pu)";
  Complex Imot_pu "per unit current across motor(pu)";
  Modelica.SIunits.ComplexCurrent Imot "Current across motor";
  //in fault
  Complex If_pu "per unit fault current(pu)";
  Modelica.SIunits.ComplexCurrent If "Total Fault Current";
  
  constant Real pi=2*Modelica.Math.asin(1.0);
  constant Real D2R=pi/180 "Degree to Radian";
  constant Real R2D=180/pi "Radian to Degree";
  parameter OpenIPSL.Types.ApparentPowerMega S= 30 "rating of generator & motor(KVA)";
  parameter OpenIPSL.Types.VoltageKilo V= 13.2 "voltage rating of generator & motor(KV)";
  parameter Complex X2d= Complex(0, 0.2) "reactance of generator & motor";
  parameter OpenIPSL.Types.ActivePowerMega Sl= 20 "power drawn by motor(KW)";
  parameter Real pf= 0.8 "power factor";
  parameter OpenIPSL.Types.VoltageKilo Vt_mot= 12.8 "terminal voltage of motor(KV)";
  parameter OpenIPSL.Types.VoltageKilo Vb= V"Base voltage(KV)";
  parameter Complex Xt= Complex(0, 0.1) "transmission line reactance";
  parameter OpenIPSL.Types.ApparentPowerMega Sb= S "base power (KVA)";
  
equation
  Vf= Vt_mot/V;
  Ib= (S*1e3)/(V*sqrt(3));
  Il= (Sl*1e3)/(pf*Vt_mot*sqrt(3));
  Il_arg= acos(pf);
  Il_pu_abs= Il/Ib;
  Il_pu= Complex(Il_pu_abs*cos(Il_arg), Il_pu_abs*sin(Il_arg));
  Vt_gen= Vf+ Xt*Il_pu;
  Egen= Vt_gen+X2d*Il_pu;
  Igen_pu= Egen/(Xt+X2d);
  Igen= Ib*Igen_pu;
  Vter= Vf;
  Emot= Vter-X2d*Il_pu;
  Imot_pu= Emot/(X2d);
  Imot= Ib*Imot_pu;
  If_pu= Igen_pu+Imot_pu;
  If= Ib*If_pu;
 
//"The  answer may slightly vary due to  rounding off values" 

end Ex10_2;
