model Ex11_4

  Real X0_mo1 (final unit= "per unit") "zero sequence reactance of motor1";
  Real X0_mo2 (final unit= "per unit") "zero sequence reactance of motor2";
  Modelica.SIunits.Impedance Zb_gen "base impedance in generator circuit";
  Modelica.SIunits.Impedance Zb_mot "base impedance in motor circuit";
  Real Zgen (final unit= "per unit") "impedance network for generator";
  Real Zmot (final unit= "per unit") "impedance network for motor";
  Real X0_tl (final unit= "per unit") "reactance for transmission line";
  
  parameter OpenIPSL.Types.ApparentPowerMega Sb = 300 "refer Ex_6_10";
  parameter OpenIPSL.Types.VoltageKilo Vb = 20 "refer Ex_6_10";
  parameter OpenIPSL.Types.VoltageKilo Vmotor = 13.2 "refer Ex_6_10";
  parameter OpenIPSL.Types.ApparentPowerMega Sn_m1 = 200 "refer Ex_6_10";
  parameter OpenIPSL.Types.ApparentPowerMega Sn_m2 = 100 "refer Ex_6_10";
  parameter OpenIPSL.Types.VoltageKilo Vmc= 13.8 "refer Ex_6_10";
  parameter Real Xtr1 (final unit= "per unit")= 0.0857 "refer Ex_6_10";
  parameter Real Xtr2 (final unit= "per unit")= 0.0915 "refer Ex_6_10";
  parameter Modelica.SIunits.Impedance Zb_tl= 176.3 "refer Ex_6_10";
  parameter Real length (final unit= "km")= 64 "length of transmission line";
  parameter Real X0 (final unit= "per unit")= 0.05 "zero sequence reactance of generator";
  parameter Modelica.SIunits.Resistance X_lim = 0.4 "current limiting reactors";
  parameter Real X_tl (final unit= "ohm/km")= 1.5 "zero sequence reactance of transmission line";
  
equation
  X0_mo1= X0*((Sb/Sn_m1)*((Vmotor/Vmc)^2));
  X0_mo2= X0*((Sb/Sn_m2)*((Vmotor/Vmc)^2));
  Zb_gen= (Vb^2)/Sb;
  Zb_mot= (Vmc^2)/Sb;
  Zgen= 3*(X_lim/Zb_gen);
  Zmot= 3*(X_lim/Zb_mot);
  X0_tl= (X_tl*length)/(Zb_tl);
 
//"The  answer may slightly vary due to  rounding off values" 

end Ex11_4;
