model Ex12_1

  Complex Ia1 "line current";
  Complex Ia_pu "subtransient current in line a (pu)";
  Modelica.SIunits.Current Ib "base current";
  Modelica.SIunits.ComplexCurrent Ia "subtransient current in line a in A";
  Complex Va1 "positive sequence voltage in line a";
  Complex Va2 "negative sequence voltage in line a";
  Complex Va0 "zero sequence voltage in line a";
  Complex Va "total voltage in line a";
  Complex Vb "total voltage in line b";
  Complex Vc "total voltage in line c";
  Complex Vab "line to line voltage(pu)";
  Real Vab_abs (final unit= "per unit") "magnitude of Vab";
  Modelica.SIunits.Angle Vab_arg "argument of Vab";
  Complex Vbc "line to line voltage(pu)";
  Real Vbc_abs (final unit= "per unit") "magnitude of Vbc";
  Modelica.SIunits.Angle Vbc_arg "argument of Vbc";
  Complex Vca "line to line voltage(pu)";
  Real Vca_abs (final unit= "per unit") "magnitude of Vca";
  Modelica.SIunits.Angle Vca_arg "argument of Vca";
  Complex Vab_ll "line to line voltage in KV";
  OpenIPSL.Types.VoltageKilo Vab_ll_abs "magnitude of Vab_ll";
  Modelica.SIunits.Angle Vab_ll_arg "argument of Vab_ll";
  Complex Vbc_ll "line to line voltage in KV";
  OpenIPSL.Types.VoltageKilo Vbc_ll_abs "magnitude of Vbc_ll";
  Modelica.SIunits.Angle Vbc_ll_arg "argument of Vbc_ll";
  Complex Vca_ll "line to line voltage in KV";
  OpenIPSL.Types.VoltageKilo Vca_ll_abs "magnitude of Vca_ll";
  Modelica.SIunits.Angle Vca_ll_arg "argument of Vca_ll";

  constant Real pi=2*Modelica.Math.asin(1.0);
  constant Real D2R=pi/180 "Degree to Radian";
  constant Real R2D=180/pi "Radian to Degree";
  parameter OpenIPSL.Types.ApparentPowerMega Sb= 20 "base power of the generator in MVA";
  parameter OpenIPSL.Types.VoltageKilo Eb= 13.8 "base voltage of generatorin KV";
  parameter Real Ea (final unit= "per unit")= 1.0 "per unit voltage";
  parameter Complex Z0= Complex(0, 0.10) "zero sequence reactance";
  parameter Complex Z1= Complex(0, 0.25) "sub transient reactance";
  parameter Complex Z2= Complex(0, 0.35) "negative sequence reactance";
  parameter Complex a= Complex(1*cos(120*D2R), 1*sin(120*D2R)) "operator";
  parameter Complex a2= Complex(1*cos(240*D2R), 1*sin(240*D2R)) "operator";
 
equation
  Ia1= Ea/(Z1+Z2+Z0);
  Ia_pu= 3*Ia1;
  Ib= (Sb*1e3)/(Eb*sqrt(3));
  Ia= Ia_pu*Ib;
  Va1= Ea-(Ia1*Z1);
  Va2= -(Ia1*Z2);
  Va0= -(Ia1*Z0);
  Va= Va1+Va2+Va0;
  Vb= (a2*Va1)+(a*Va2)+Va0;
  Vc= (a*Va1)+(a2*Va2)+Va0;
  Vab= Va-Vb;
  Vab_abs= sqrt((Vab.re^2)+(Vab.im^2));
  Vab_arg= ((atan(Vab.im/Vab.re)));
  Vbc= Vb-Vc;
  Vbc_abs= sqrt((Vbc.re^2)+(Vbc.im^2));
  Vbc_arg= ((atan(Vbc.im/Vbc.re)))+pi;
  Vca= Vc-Va;
  Vca_abs= sqrt((Vca.re^2)+(Vca.im^2));
  Vca_arg= ((atan(Vca.im/Vca.re)))+pi;
  Vab_ll= (Vab*Eb)/sqrt(3);
  Vab_ll_abs= sqrt((Vab_ll.re^2)+(Vab_ll.im^2));
  Vab_ll_arg= ((atan(Vab_ll.im/Vab_ll.re)));
  Vbc_ll= (Vbc*Eb)/sqrt(3);
  Vbc_ll_abs= sqrt((Vbc_ll.re^2)+(Vbc_ll.im^2));
  Vbc_ll_arg= ((atan(Vbc_ll.im/Vbc_ll.re)))+pi;
  Vca_ll= (Vca*Eb)/sqrt(3);
  Vca_ll_abs= sqrt((Vca_ll.re^2)+(Vca_ll.im^2));
  Vca_ll_arg= ((atan(Vca_ll.im/Vca_ll.re)))+pi;//+180;
   
//"The  answer may slightly vary due to  rounding off values" 

end Ex12_1;
