model Ex12_2

  Complex Ia1 "line current in line a for positive sequence";
  Complex Ia2 "line current in line a for negative sequence";
  Complex Ia0 "line current in line a for zero sequence";
  Complex Ia_pu "subtransient current in line a (pu)";
  Modelica.SIunits.ComplexCurrent Ia "subtransient current in line a in A";
  Complex Ib_pu "subtransient current in line b (pu)";
  Modelica.SIunits.ComplexCurrent Ib "subtransient current in line b in A";
  Modelica.SIunits.Current Ib_abs "magnitude of Ib";
  Modelica.SIunits.Angle Ib_arg "argument of Ib";
  Complex Ic_pu "subtransient current in line c (pu)";
  Modelica.SIunits.ComplexCurrent Ic "subtransient current in line c in A";
  Modelica.SIunits.Current Ic_abs "magnitude of Ic";
  Modelica.SIunits.Angle Ic_arg "argument of Ic";
  Complex Va1 "symmetrical components of voltage from a to ground in pu";
  Complex Va2 "symmetrical components of voltage from a to ground in pu";
  Complex Va0 "symmetrical components of voltage from a to ground in pu";
  Complex Va "line to ground voltage in pu";
  Complex Vb "line to line voltage in pu";
  Complex Vc "line to line voltage in pu";
  Complex Vab "line to line voltage in pu";
  Real Vab_abs (final unit= "per unit") "magnitude of Vab";
  Modelica.SIunits.Angle Vab_arg "argument of Vab";
  Complex Vbc "line to line voltage in pu";
  Complex Vca "line to line voltage in pu";
  Real Vca_abs (final unit= "per unit") "magnitude of Vca";
  Modelica.SIunits.Angle Vca_arg "argument of Vca";
  Complex Vab_ll "line to line voltage in KV";
  OpenIPSL.Types.VoltageKilo Vab_ll_abs "magnitude of Vab_ll";
  Modelica.SIunits.Angle Vab_ll_arg "argument of Vab_ll";
  Complex Vbc_ll "line to line voltage in KV";
  Complex Vca_ll "line to line voltage in KV";
  OpenIPSL.Types.VoltageKilo Vca_ll_abs "magnitude of Vca_ll";
  Modelica.SIunits.Angle Vca_ll_arg "argument of Vca_ll";

  constant Real pi=2*Modelica.Math.asin(1.0);
  constant Real D2R=pi/180 "Degree to Radian";
  constant Real R2D=180/pi "Radian to Degree";
  parameter OpenIPSL.Types.ApparentPowerMega Sb= 20 "base power of the generator in MVA";
  parameter OpenIPSL.Types.VoltageKilo Eb= 13.8 "base voltage of generatorin KV";
  parameter Modelica.SIunits.Current I_b= (Sb*1e3)/(Eb*(sqrt(3))) "base current in A";
  parameter Real Ea (final unit= "per unit")= 1.0 "per unit voltage";
  parameter Complex Z1= Complex(0, 0.25) "sub transient reactance";
  parameter Complex Z2= Complex(0, 0.35) "negative sequence reactance";
  parameter Complex a= Complex(1*cos(120*D2R), 1*sin(120*D2R));
  parameter Complex a2= Complex(1*cos(240*D2R), 1*sin(240*D2R));
 
equation
  Ia1= Ea/(Z1+Z2);
  Ia2= -Ia1;
  Ia0= Complex(0, 0);
  Ia_pu= Ia1+Ia2;
  Ia= Ia_pu*I_b;
  Ib_pu= (a2*Ia1)+(a*Ia2);
  Ib= Ib_pu*I_b;
  Ib_abs= sqrt((Ib.re^2)+(Ib.im^2));
  Ib_arg= ((atan(Ib.im/Ib.re)))+pi;//+180;;
  Ic_pu= -Ib_pu;
  Ic= Ic_pu*I_b;
  Ic_abs= sqrt((Ic.re^2)+(Ic.im^2));
  Ic_arg= ((atan(Ic.im/Ic.re)));
  Va1= Ea-(Ia1*Z1);
  Va2= Va1;
  Va0= Complex(0, 0);
  Va= Va1+Va2+Va0;
  Vb= (a2*Va1)+(a*Va2)+Va0;
  Vc= Vb;
  Vab= Va-Vb;
  Vab_abs= sqrt((Vab.re^2)+(Vab.im^2));
  Vab_arg= ((atan(Vab.im/Vab.re)));
  Vbc= Vb-Vc;
  Vca= Vc-Va;
  Vca_abs= sqrt((Vca.re^2)+(Vca.im^2));
  Vca_arg= ((atan(Vca.im/Vca.re)))+pi;//+180;
  Vab_ll= (Vab*Eb)/sqrt(3);
  Vab_ll_abs= sqrt((Vab_ll.re^2)+(Vab_ll.im^2));
  Vab_ll_arg= ((atan(Vab_ll.im/Vab_ll.re)));
  Vbc_ll= (Vbc*Eb)/sqrt(3);  
  Vca_ll= (Vca*Eb)/sqrt(3);
  Vca_ll_abs= sqrt((Vca_ll.re^2)+(Vca_ll.im^2));
  Vca_ll_arg= ((atan(Vca_ll.im/Vca_ll.re)))+pi;//+180;
 
//"The  answer may slightly vary due to  rounding off values" 

end Ex12_2;
