model Ex3_2
Modelica.SIunits.Length Dm "GMD of conductor between side X & Y" ;
  Modelica.SIunits.Length Dsx "GMR of conductor of side X";
  Modelica.SIunits.Length Dsy "GMR of conductor of side Y";
  Real Lx (final unit="H/m") "inductance of side X";
  Real Ly (final unit="H/m") "inductance of side Y";
  Real L (final unit="H/m") " total inductance";
  Real L1 (final unit="mH/mile") "total inductance";
  parameter Modelica.SIunits.Length Dad= 9 "Diameter of the conductor a and d";
  parameter Modelica.SIunits.Length Dbe= 9 "Diameter of the conductor b and e";
  parameter Modelica.SIunits.Length Dde= 6 "Diameter of the conductor d and e";
  parameter Modelica.SIunits.Length Ded= Dde "Diameter of the conductor e and d";
  parameter Modelica.SIunits.Length Dab= 6 "Diameter of the conductor a and b";
  parameter Modelica.SIunits.Length Dba= Dab "Diameter of the conductor b and a";
  parameter Modelica.SIunits.Length Dbc= 6 "Diameter of the conductor b and c";
  parameter Modelica.SIunits.Length Dcb= Dbc "Diameter of the conductor c and b";
  parameter Modelica.SIunits.Length Dac= 12 "Diameter of the conductor a and c";
  parameter Modelica.SIunits.Length Dca= Dac "Diameter of the conductor c and a";
  parameter Modelica.SIunits.Length Dae= sqrt((Dad^2)+(Dde^2)) "Diameter of the conductor a and e";
  parameter Modelica.SIunits.Length Dbd= sqrt((Dad^2)+(Dab^2)) "Diameter of the conductor b and d";
  parameter Modelica.SIunits.Length Dce= sqrt((Dbe^2)+(Dbc^2)) "Diameter of the conductor c and e";
  parameter Modelica.SIunits.Length Dcd= sqrt((Dad^2)+(Dac^2)) "Diameter of the conductor c and d";
  parameter Modelica.SIunits.Length Daa = 0.25*0.7788*0.01 "Diameter of the conductor a";
  parameter Modelica.SIunits.Length Dbb = Daa "Diameter of the conductor b";
  parameter Modelica.SIunits.Length Dcc = Dbb "Diameter of the conductor c";
  parameter Modelica.SIunits.Length Ddd= 0.5*0.7788*0.01 "Diameter of the conductor d";
  parameter Modelica.SIunits.Length Dee= Ddd "Diameter of the conductor e";

equation
  Dm= (Dad*Dae*Dbd*Dbe*Dcd*Dce)^(1/6);
  Dsx= (Daa*Dab*Dac*Dba*Dbb*Dbc*Dca*Dcb*Dcc)^(1/9);
  Dsy= (Ddd*Dde*Ded*Dee)^(1/4);
  Lx= 2*0.0000001*(log(Dm/Dsx));
  Ly= 2*0.0000001*(log(Dm/Dsy));
  L1= 1609000*L;
  L= Lx+Ly;
 
//"The  answer may slightly vary due to  rounding off values" 
end Ex3_2;
