model Ex3_6
Real Dab (final unit="ft") "Diameter of the conductor a and b";
  Real Dab1 (final unit="ft") "Diameter of the conductor a and b'";
  Real Dpab (final unit="ft") "GMD between phases of conductor a and b";
  Real Dpbc (final unit="ft") "GMD between phases of conductor b and c";
  Real Dpac (final unit="ft") "GMD between phases of conductor a and c";
  Real Deq (final unit="ft") "Geometric mean of the distances between the conductors";
  Real Daa (final unit="ft") "GMR of the conductor a";
  Real Daa1 (final unit="ft") "GMR of the conductor a and a'";
  Real Dbb1 (final unit="ft") "GMR of the conductor b and b'";
  Real Dcc1 (final unit="ft") "GMR of the conductor c and c'";
  Real Dsp (final unit="ft") "Geometric mean of the GMR values of the conductors";
  Real L (final unit="H/m per phase") "inductance";
  Real Xl (final unit="ohm/mi per phase") "Inductive reactance";
  
  constant Real pi=2*Modelica.Math.asin(1.0);
  parameter Real Ds (final unit="ft")= 0.0229 "GMR of the conductor";
  parameter Real Da (final unit="ft")= 10 "Diameter of conductor a";
  parameter Real Db (final unit="ft")= 1.5 "Diameter of conductor b";
  parameter Real Db1 (final unit="ft")= 19.5 "Diameter of conductor b'";
  parameter Real Dbb (final unit="ft")= 21 "GMR of conductor b";
  parameter Real Dc (final unit="ft")= 18 "Diameter of conductor c"; 
  parameter Modelica.SIunits.Frequency f= 60 "frequency";

equation
  Dab= (((Da)^2)+((Db)^2))^(0.5);
  Dab1= (((Da)^2)+((Db1)^2))^(0.5);
  Dpab= ((Dab*Dab1)^(2))^(1/4);
  Dpbc= Dpab;
  Dpac= ((2*Da*Dc)^(2))^(1/4);
  Deq= (Dpab*Dpac*Dpbc)^(1/3);
  Daa= (((2*Da)^2)+((Dc)^2))^(0.5);
  Daa1= (Daa*Ds)^(0.5);
  Dbb1= (Dbb*Ds)^(0.5);
  Dcc1= (Daa*Ds)^(0.5);
  Dsp= (Daa1*Dbb1*Dcc1)^(1/3);
  L= 0.0000002*((log(Deq/Dsp)));
  Xl= 2*f*pi*1609*L;
 
//"The  answer may slightly vary due to  rounding off values" 
end Ex3_6;
