model Ex4_2
Real r (final unit="ft") "radius of the conductor";
  Real Cn (final unit="F/m") "capacitance to neutral";
  Real Xc (final unit="ohm.mi") "capacitive reactance";
  Real Xc1 (final unit="ohm.mi to neutral") "capacitive reactance";
  Real Xc2 (final unit="ohm to neutral") "capacitive reactance";
  Real Ichg (final unit="A/mi") "charging current per mile";
  Modelica.SIunits.Current I "total charging current";
  OpenIPSL.Types.ReactivePowerMega Q "Total charging megavolt-amperes";
  
  constant Real pi=2*Modelica.Math.asin(1.0);
  parameter Real Deq (final unit="ft")= 24.8 "Geometric mean of the conductor";
  parameter Real Ds (final unit="ft")= 1.108 "GMR of the conductor";
  parameter Real l (final unit="mi")= 175 "length of the line";
  parameter OpenIPSL.Types.VoltageKilo V_b= 220 "normal operating voltage";
  parameter Real Xa1= 0.0912e6 "capacitive reactance obtained from table A.1";
  parameter Real Xd1= 0.0953e6 "capacitive reactance obtained from table A.1";
  parameter Modelica.SIunits.Frequency f= 60 "frequency";
  
equation
   r= Ds/(2*12);
   Cn= (2*pi*8.85e-12)/(log(Deq/r));
   Xc= 1/(2*pi*f*Cn*1609);
   Xc1= Xa1+Xd1;
   Xc2= Xc1/l;
   Ichg= (2*pi*f*V_b*1e3*Cn*1609)/((3)^(0.5));
   I= Ichg*l;
   Q= sqrt(3)*V_b*I*1e-3;
    
//"The  answer may slightly vary due to  rounding off values" 
end Ex4_2;
