model Ex6_9

  Real R (final unit= "per unit") "Base Load Resistance";
  Real X2d_pu (final unit= "per unit") "Subtransient Reactance";
  
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Resistor resistor1(R_ref = 3)  annotation(
    Placement(visible = true, transformation(origin = {24, -34}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance1(Z_ref (re= 0, im= 0.02))  annotation(
    Placement(visible = true, transformation(origin = {-46, 50}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance2(Z_ref (re= 0, im= 0.07))  annotation(
    Placement(visible = true, transformation(origin = {8, 4}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance3(Z_ref (re= 0, im= 0.05))  annotation(
    Placement(visible = true, transformation(origin = {6, 80}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance4(Z_ref (re= 0, im= 0.4))  annotation(
    Placement(visible = true, transformation(origin = {66, 42}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Ground ground1 annotation(
    Placement(visible = true, transformation(origin = {-78, -78}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Ground ground2 annotation(
    Placement(visible = true, transformation(origin = {24, -90}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Ground ground3 annotation(
    Placement(visible = true, transformation(origin = {66, -86}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Sources.VoltageSource voltageSource1(V = 2300, f = 50, phi = 0)  annotation(
    Placement(visible = true, transformation(origin = {-78, -2}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Sources.VoltageSource voltageSource2(V = 13200, f = 50, phi = 0)  annotation(
    Placement(visible = true, transformation(origin = {66, -30}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));

  parameter OpenIPSL.Types.ActivePowerMega Sn1= 5 "Power rating of infinite bus in MW";
  parameter OpenIPSL.Types.ApparentPowerMega Sn2= 7.5 "Power rating of synchronous motor in MVA";
  parameter OpenIPSL.Types.ApparentPowerMega Sb= 15 "Base power in MVA";
  parameter OpenIPSL.Types.VoltageKilo Vb= 66 "Base voltgage in KV";
  parameter Real X2d (final unit= "per unit")= 0.20 "subtransient reactance of motor";
  parameter Real r (final unit= "per unit")= 1 "resistive load in per unit";
  
  
equation
  
  connect(voltageSource1.pin_n, ground1.pin) annotation(
    Line(points = {{-78, -12}, {-78, -68}}, color = {85, 170, 255}));
  connect(voltageSource2.pin_n, ground3.pin) annotation(
    Line(points = {{66, -40}, {66, -76}}, color = {85, 170, 255}));
  connect(impedance3.pin_n, impedance4.pin_p) annotation(
    Line(points = {{16, 80}, {66, 80}, {66, 52}}, color = {85, 170, 255}));
  connect(impedance4.pin_n, voltageSource2.pin_p) annotation(
    Line(points = {{66, 32}, {66, -20}}, color = {85, 170, 255}));
  connect(resistor1.pin_n, ground2.pin) annotation(
    Line(points = {{24, -44}, {24, -80}}, color = {85, 170, 255}));
  
  R= r*(Sb/Sn1);
  X2d_pu= X2d*(Sb/Sn2);
  connect(impedance2.pin_n, resistor1.pin_p) annotation(
    Line(points = {{18, 4}, {24, 4}, {24, -24}}, color = {85, 170, 255}));
  connect(impedance1.pin_n, impedance2.pin_p) annotation(
    Line(points = {{-36, 50}, {-10, 50}, {-10, 4}, {-2, 4}}, color = {85, 170, 255}));
  connect(impedance1.pin_n, impedance3.pin_p) annotation(
    Line(points = {{-36, 50}, {-10, 50}, {-10, 80}, {-4, 80}, {-4, 80}, {-4, 80}}, color = {85, 170, 255}));
  connect(voltageSource1.pin_p, impedance1.pin_p) annotation(
    Line(points = {{-78, 8}, {-80, 8}, {-80, 50}, {-56, 50}, {-56, 50}}, color = {85, 170, 255}));
 
//"The  answer may slightly vary due to  rounding off values" 

end Ex6_9;
