model Ex7_5

  Complex Ic "current across capacitor (pu)";
  Real Ic_abs (final unit= "per unit") "magnitude of Ic";
  Modelica.SIunits.Angle Ic_arg "argument of Ic";

  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance1(Z_ref(re=0, im=1.25))  annotation(
    Placement(visible = true, transformation(origin = {-46, 70}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance2(Z_ref(re= 0, im=1.25))  annotation(
    Placement(visible = true, transformation(origin = {-46, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance3(Z_ref(re= 0, im= 1.25))  annotation(
    Placement(visible = true, transformation(origin = {-46, -72}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance4(Z_ref(re= 0, im= 0.25))  annotation(
    Placement(visible = true, transformation(origin = {-8, 32}, extent = {{10, -10}, {-10, 10}}, rotation = 90)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance5(Z_ref(re= 0, im= 0.4))  annotation(
    Placement(visible = true, transformation(origin = {-8, -36}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance6(Z_ref(re= 0, im= 0.125))  annotation(
    Placement(visible = true, transformation(origin = {28, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance7(Z_ref(re= 0, im= 0.2))  annotation(
    Placement(visible = true, transformation(origin = {40, 60}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance8(Z_ref(re= 0, im= 0.2))  annotation(
    Placement(visible = true, transformation(origin = {40, -60}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Ground ground1 annotation(
    Placement(visible = true, transformation(origin = {90, -92}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Sources.VoltageSource voltageSource1(V = 1.5, f = 50, phi = 0)  annotation(
    Placement(visible = true, transformation(origin = {-80, 70}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Sources.VoltageSource voltageSource2(V = 1.5, f = 50, phi = -0.643503)  annotation(
    Placement(visible = true, transformation(origin = {-80, -72}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Sources.VoltageSource voltageSource3(V = 1.5, f = 50, phi = 0)  annotation(
    Placement(visible = true, transformation(origin = {-80, 0}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Capacitor capacitor1(C = 0.0006366)  annotation(
    Placement(visible = true, transformation(origin = {72, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  
  constant Real pi=2*Modelica.Math.asin(1.0); 
  constant Real D2R=pi/180 "Degree to Radian";
  constant Real R2D=180/pi "Radian to Degree";
  parameter Complex Xc= Complex(0,5) "reactance of Capacitor";
  parameter Complex Eth= Complex(1.432*cos(-11.97*D2R),1.432*sin(-11.97*D2R)) "thevenin voltage of circuit at node 4: also refer Ex_7_1";
  parameter Complex Zth= Complex(0, 0.4733) "thevenin voltage at node 4";

equation
  Ic= Eth/(Zth-Xc);
  Ic_abs= sqrt((Ic.re^2)+(Ic.im^2));
  Ic_arg= atan(Ic.im/Ic.re); 

  connect(capacitor1.pin_n, ground1.pin) annotation(
    Line(points = {{82, 0}, {90, 0}, {90, -82}, {90, -82}, {90, -82}}, color = {85, 170, 255}));
  connect(impedance6.pin_n, capacitor1.pin_p) annotation(
    Line(points = {{38, 0}, {62, 0}, {62, 0}, {62, 0}}, color = {85, 170, 255}));
  connect(impedance8.pin_n, ground1.pin) annotation(
    Line(points = {{50, -60}, {90, -60}, {90, -82}, {90, -82}, {90, -82}}, color = {85, 170, 255}));
  connect(voltageSource2.pin_n, ground1.pin) annotation(
    Line(points = {{-90, -72}, {-96, -72}, {-96, -82}, {90, -82}, {90, -82}}, color = {85, 170, 255}));
  connect(voltageSource3.pin_n, ground1.pin) annotation(
    Line(points = {{-90, 0}, {-96, 0}, {-96, -82}, {90, -82}, {90, -82}}, color = {85, 170, 255}));
  connect(voltageSource1.pin_n, ground1.pin) annotation(
    Line(points = {{-90, 70}, {-96, 70}, {-96, -82}, {90, -82}, {90, -82}}, color = {85, 170, 255}));
  connect(impedance8.pin_p, impedance3.pin_n) annotation(
    Line(points = {{30, -60}, {-8, -60}, {-8, -72}, {-36, -72}, {-36, -72}}, color = {85, 170, 255}));
  connect(impedance1.pin_n, impedance7.pin_p) annotation(
    Line(points = {{-36, 70}, {-8, 70}, {-8, 60}, {30, 60}, {30, 60}}, color = {85, 170, 255}));
  connect(impedance5.pin_n, impedance3.pin_n) annotation(
    Line(points = {{-8, -46}, {-8, -46}, {-8, -72}, {-36, -72}, {-36, -72}}, color = {85, 170, 255}));
  connect(impedance5.pin_p, impedance2.pin_n) annotation(
    Line(points = {{-8, -26}, {-8, 0}, {-36, 0}}, color = {85, 170, 255}));
  connect(impedance2.pin_n, impedance6.pin_p) annotation(
    Line(points = {{-36, 0}, {16, 0}, {16, 0}, {18, 0}}, color = {85, 170, 255}));
  connect(impedance4.pin_n, impedance2.pin_n) annotation(
    Line(points = {{-8, 22}, {-8, 22}, {-8, 0}, {-36, 0}, {-36, 0}}, color = {85, 170, 255}));
  connect(impedance1.pin_n, impedance4.pin_p) annotation(
    Line(points = {{-36, 70}, {-8, 70}, {-8, 42}, {-8, 42}}, color = {85, 170, 255}));
  connect(voltageSource2.pin_p, impedance3.pin_p) annotation(
    Line(points = {{-70, -72}, {-56, -72}}, color = {85, 170, 255}));
  connect(voltageSource3.pin_p, impedance2.pin_p) annotation(
    Line(points = {{-70, 0}, {-56, 0}}, color = {85, 170, 255}));
  connect(voltageSource1.pin_p, impedance1.pin_p) annotation(
    Line(points = {{-70, 70}, {-56, 70}}, color = {85, 170, 255}));
 
//"The  answer may slightly vary due to  rounding off values" 

end Ex7_5;
