model Ex8_4

  Complex I2 "Current across Z in pu";
  Complex Y21_tra "node 1 admittance for transformer a alone(pu)";
  Complex Y22_tra "node 2 admittance for transformer a alone(pu)";
  Complex Y21_trb "node 1 admittance for transformer b alone(pu)";
  Real Y21_trb_abs (final unit= "per unit") "magnitude of Y21_trb";
  Modelica.SIunits.Angle Y21_trb_arg "argument of Y21_trb";
  Complex Y22_trb "node 2 admittance for transformer b alone(pu)";
  Complex Y21 "node 1 admittance for transformer a & b in parallel(pu)";
  Complex Y22 "node 2 admittance for transformer a & b in parallel(pu)";
  Complex V1 "voltage L-T side (pu)";
  Complex Ita "current across transformer a(pu)";
  Complex Itb "current in transformer b (pu)";
  Complex Sta "total power in transformer a(pu)";
  Complex Stb "total power in transformer a(pu)";
  
  constant Real pi=2*Modelica.Math.asin(1.0);
  constant Real D2R=pi/180 "Degree to Radian";
  constant Real R2D=180/pi "Radian to Degree";
  parameter Complex Z= Complex(0.8, 0.6) "impedance in pu";
  parameter Real V2= 1.0 "voltage across impedance Z(pu)";
  parameter Complex a= Complex(1*cos(3*D2R), 1*sin(3*D2R)) "tap windings";
  parameter Real a_abs= sqrt(a.re ^ 2 + a.im ^ 2) "magnitude of a";
  parameter Complex Za= Complex(0, 0.1) "impedance of transformer a(pu)";
  parameter Complex Zb= Complex(0, 0.1) "impedance of transformer b(pu)";
  
equation
  I2= -(V2)/(Z);
  Y21_tra= -1/Za;
  Y22_tra= 1/Za;
  Y21_trb= -(1/Zb)/(Complex(a.re, -a.im));
  Y21_trb_abs= sqrt(Y21_trb.re ^ 2 + Y21_trb.im ^ 2);
  Y21_trb_arg = atan(Y21_trb.im / Y21_trb.re);
  Y22_trb= (1/Zb)/(a_abs^2);
  Y21= Y21_tra+Y21_trb;
  Y22= Y22_tra+Y22_trb;
  V1= (I2-(Y22*V2))/Y21;
  //V= V1-V2;
  Ita= (V1-V2)*Y22_tra;
  //Ita_conj= Complex(Ita.re, -Ita.im);
  Itb= -I2-Ita;
  //Itb_conj= Complex(Itb.re, -Itb.im);
  Sta= V2*(Complex(Ita.re, -Ita.im));
  Stb= (Complex(Itb.re, -Itb.im))*V2;
   
//"The  answer may slightly vary due to  rounding off values" 

end Ex8_4;
