model Ex9_2

  Real Df1 (final unit= "$/hr") "incremental fuel cost for unit 1";
  Real Df2 (final unit= "$/hr") "incremental fuel cost for unit 2";
  Real Df (final unit= "$/hr") "net increase in cost";
  parameter OpenIPSL.Types.ActivePowerMega P1max= 450 "max power of unit 1";
  parameter OpenIPSL.Types.ActivePowerMega P1min= 400 "min power of unit 1";
  parameter OpenIPSL.Types.ActivePowerMega P2max= 450 "max power of unit 2";
  parameter OpenIPSL.Types.ActivePowerMega P2min= 500 "max power of unit 2";
  
equation
  Df1= 0.004*((P1max^2)-(P1min^2))+8*(P1max-P1min);
  Df2= 0.0048*((P2max^2)-(P2min^2))+6.4*(P2max-P2min);
  Df= Df1+Df2;
   
//"The  answer may slightly vary due to  rounding off values" 

end Ex9_2;
