model Ex10_3

  Complex Zth "Thevenin resistance in pu";
  Complex If_pu "fault current(pu)";
  Modelica.SIunits.ComplexCurrent If "fault current";
  Complex If_gen_pu "fault current from generator(pu)";
  Modelica.SIunits.ComplexCurrent If_gen "fault current from generator";
  Complex If_mot_pu "fault current from motor(pu)";
  Modelica.SIunits.ComplexCurrent If_mot "fault current from motor";
  Complex Igen_pu "per unit current across generator(pu)";
  Complex Imot_pu "per unit current across motor(pu)";
  
  parameter Complex X2d= Complex(0, 0.2) "reactance of generator & motor";
  parameter Complex Xt= Complex(0, 0.1) "transformer reactance";
  parameter Real Vf (final unit= "per unit")= 0.97 "refer Ex_10_2";
  parameter Complex Il_pu= Complex(0.69, 0.52) "refer to Ex_10_2";
  parameter Modelica.SIunits.Current Ib= 1312 "refer to Ex_10_2";
  
equation
  Zth= ((Xt+X2d)*X2d)/(Xt+X2d+X2d);
  If_pu= Vf/Zth;
  If_gen_pu= If_pu*(X2d/(Xt+X2d+X2d));
  If_mot_pu= If_pu*((X2d+Xt))/(Xt+X2d+X2d);
  Igen_pu= Il_pu+If_gen_pu;
  Imot_pu= -Il_pu+If_mot_pu;
  If_gen= If_gen_pu*Ib;
  If_mot= If_mot_pu*Ib;
  If= If_pu*Ib;
 
//"The  answer may slightly vary due to  rounding off values" 

end Ex10_3;
