model Ex12_5

  Complex [2,2]Ybus_1 "admittance of bus for positive sequence network";
  Complex [2,2]Ybus_2 "admittance of bus for negative sequence network";
  Complex [2,2]Ybus_0 "admittance of bus for zero sequence network";
  Complex [2,2]Zbus_1 "impedance of bus for positive sequence network";
  Complex [2,2]Zbus_2 "impedance of bus for negative sequence network";
  Complex [2,2]Zbus_0 "impedance of bus for zero sequence network";
  Complex If_bus1 "fault current in bus 1";
  Complex If_bus2 "fault current in bus 2";
  Complex Ia1 "positive sequence current in line a";
  Complex Ia2 "negative sequence current in line a";
  Complex Ia0 "zero sequence current in line a";
  Complex Va1 "positive sequence voltage in line a";
  Complex Va2 "positive sequence voltage in line b";
  Complex Va0 "positive sequence voltage in line c";
  Complex V_A1 "positive sequence voltage in line a due to phase shift";
  Complex V_A2 "negative sequence voltage in line a due to phase shift";
  Complex V_A "total voltage in line a";
  Complex V_B "total voltage in line b";
  Complex V_C "total voltage in line c";

  constant Real pi=2*Modelica.Math.asin(1.0);
  constant Real D2R=pi/180 "Degree to Radian";
  constant Real R2D=180/pi "Radian to Degree";
  parameter Complex Z1_mot= Complex(0, 0.30) "refer Ex_12_4";
  parameter Complex Z1_2= Complex(0, 0.10) "refer Ex_12_4";
  parameter Complex Z1_0= Complex(0, 0.15) "refer Ex_12_4";
  parameter Complex Z2_gen= Complex(0, 0.10) "refer Ex_12_4";
  parameter Complex Z2_0= Complex(0, 0.2) "refer Ex_12_4";
  parameter Complex Y11_1= (1/Z1_mot)+(1/Z1_2) "admittance on bus 1 for positive sequence network";
  parameter Complex Y11_2= Y11_1 "admittance on bus 1 for negative sequence network";
  parameter Complex Y11_0= 1/Z1_0  "admittance on bus 1 for zerosequence network";
  parameter Complex Y12_1= -(1/Z1_2) "admittance on bus 1-2 for positive sequence network";
  parameter Complex Y12_2= Y12_1 "admittance on bus 1-2 for negative sequence network";
  parameter Complex Y12_0= Complex(0,0) "admittance on bus 2-1 for zero sequence network";
  parameter Complex Y22_1= (1/Z1_2)+(1/Z2_gen) "admittance on bus 2 for positive sequence network";
  parameter Complex Y22_2= Y22_1 "admittance on bus 2 for negative sequence network"; 
  parameter Complex Y22_0= (1/Z2_0)+(1/Z1_2)  "admittance on bus 1 for zerosequence network"; 
  parameter Complex Y21_1= Y12_1 "admittance on bus 2-1 for positive sequence network";
  parameter Complex Y21_2= Y12_2 "admittance on bus 2-1 for positive sequence network";
  parameter Complex Y21_0= Complex(0,0) "admittance on bus 2-1 for zero sequence network";
  parameter Complex j= Complex(0, 1) "j is considered as a complex number with magnitude 1";
  parameter Complex a= Complex(1*cos(120*D2R), 1*sin(120*D2R)) "operator";
  parameter Complex a2= Complex(1*cos(240*D2R), 1*sin(240*D2R)) "operator";
  parameter Real Ea (final unit= "per unit")= 1.0 "refer Ex_12_4";
  parameter Real vf (final unit= "per unit")= 1.0 "refer Ex_12_4";
  
equation
   Ybus_1= {{Y11_1,Y12_1}, {Y21_1,Y22_1}};
   Ybus_2= Ybus_1;
   Ybus_0= {{Y11_0,Y21_0}, {Y21_0,Y22_0}};
   Zbus_1= Complex(0, -Modelica.Math.Matrices.inv(Ybus_1.im));
   Zbus_2= Zbus_1;
   Zbus_0= Complex(0, -Modelica.Math.Matrices.inv(Ybus_0.im));
   If_bus1= (3*Ea)/(Zbus_1[1,1]+Zbus_2[1,1]+Zbus_0[1,1]);
   If_bus2= (3*Ea)/(Zbus_1[2,2]+Zbus_2[2,2]+Zbus_0[2,2]);
   Ia1= If_bus1/3;
   Ia2= Ia1;
   Ia0= Ia1;
   Va1= Ea-(Ia1*Zbus_1[1,2]);
   Va2= -Ia2*Zbus_1[2,1];
   Va0= Complex(0,0);
   V_A1= -j*Va1;
   V_A2= j*Va2;
   V_A= V_A1+V_A2;
   V_B= (a2*V_A1)+(a*V_A2);
   V_C= (a2*V_A2)+(a*V_A1);
    
//"The  answer may slightly vary due to  rounding off values" 

end Ex12_5;
