model Ex13_5

  Modelica.SIunits.Current Ip_max "max current at primary";
  Modelica.SIunits.Current Is_max "min current at primary";
  Modelica.SIunits.Current I_t2r "current flowing through differential relay from L-T side";
  Modelica.SIunits.Current I_t2r_line "current flowing through each of seconadry winding of delta connected CT";
  Real CT "CT ratio";
  Modelica.SIunits.Current Is_ct "Ct secondary current";
  Modelica.SIunits.Current Il_ct "line current from delta connected CT";
  Real a "CT turns ratio";

  parameter OpenIPSL.Types.VoltageKilo Vp= 345 "voltage at the primary side of the transformer";
  parameter OpenIPSL.Types.VoltageKilo Vs= 34.5 "voltage at the secondary side of the transformer";
  parameter OpenIPSL.Types.ApparentPowerMega Sb= 50 "power rating of transformer";
  parameter OpenIPSL.Types.ApparentPowerMega S_em= 60 "short term emergency rating";
  

equation
  Ip_max= (S_em*1e6)/(Vp*1e3*sqrt(3));
  Is_max= (S_em*1e6)/(Vs*1e3*sqrt(3));
  I_t2r= Is_max*(5/1000);
  I_t2r_line= I_t2r/sqrt(3);
  CT= Ip_max/I_t2r_line;
  Is_ct= Ip_max*(5/200);
  Il_ct= Is_ct*sqrt(3);
  a= I_t2r/Il_ct;
 
//"The  answer may slightly vary due to  rounding off values" 

end Ex13_5;
