model Ex14_1

  Real Ek (final unit="ft-lb") "kinetic energy in ft-lb";
  Real H (final unit="MJ/MVA") "inertia constant in MJ/MVA";
  Real H1 (final unit="MJ/MVA") "H for 100 MVA system";

  constant Real pi=2*Modelica.Math.asin(1.0);
  parameter OpenIPSL.Types.ApparentPowerMega Sm= 1333 "power rating of the generator";
  parameter OpenIPSL.Types.ApparentPowerMega Sb= 100 "100 MVA base system";
  parameter Real N (final unit="RPM")= 1800 "speed of the generator in RPM";
  parameter Real WR2 (final unit="lb-ft^2")= 5.82e6 "moment of inertia of the machine";
  
equation
  Ek= (1/2)*(WR2/32.2)*(((2*pi*N)/60)^2);
  H= (746e-6/550)*(Ek)/(Sm);
  H1= H*(Sm/Sb);
 
//"The  answer may slightly vary due to  rounding off values" 

end Ex14_1;
