model Ex14_10
//refer Ex_14_9

  Real Pe1 (final unit="per unit") "electrical power of generator 1";
  Real Pe2 (final unit="per unit") "electrical power of generator 2";
  Real D1 (final unit="elc deg/s^2") "acceleration of generator 1 in elc deg/s^2";
  Real D2 (final unit="elc deg/s^2") "acceleration of generator 2 in elc deg/s^2";
 
 constant Real pi=2*Modelica.Math.asin(1.0);
 constant Real D2R=pi/180 "Degree to Radian";
 constant Real R2D=180/pi "Radian to Degree";
 parameter Real E1 (final unit="per unit")= 1.1 "refer Ex 14_9";
 parameter Real E2 (final unit="per unit")= 1.065 "refer Ex 14_9";
 parameter Real E3 (final unit="per unit")= 1.0 "refer Ex 14_9";
 parameter Real G11 (final unit="per unit")= 0.5005 "refer Ex 14_9";
 parameter Real Y13 (final unit="per unit")= 7.6323 "refer Ex 14_9";
 parameter Real G22 (final unit="per unit")= 0.1591 "refer Ex 14_9";
 parameter Real Y23 (final unit="per unit")= 6.0982 "refer Ex 14_9";
 parameter Modelica.SIunits.Frequency f= 50 "frequency";

equation
 Pe1= (E1^2)*G11+(E1*E3*Y13)*cos((20.82*D2R)-(91.644*D2R));
 Pe2= (E2^2)*G22+(E2*E3*Y23)*cos((16.19*D2R)-(90.847*D2R));
 D1= (180*f/11.2)*((3.5)-Pe1);
 D2= (180*f/8.0)*((1.85)-Pe2);
  
//"The  answer may slightly vary due to  rounding off values" 

end Ex14_10;
