model Ex14_6
 Real Sp "synchronizing power co-efficient at operating point";
  Real Wn(final unit = "rad/s") "angular frequency of oscillation";
  Modelica.SIunits.Frequency fn "rotor frequency";
  Modelica.SIunits.Time T "Time";
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator1(D = 0, M = 10, Sn = 500, V_0 = 1.0, V_b = 400, Vn = 400, ra = 0.001, x1d = 0.2) annotation(
    Placement(visible = true, transformation(origin = {-82, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus1(displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-22, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2 annotation(
    Placement(visible = true, transformation(origin = {52, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus1(V_0 = 1.0) annotation(
    Placement(visible = true, transformation(origin = {84, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(Sn = 500, V_b = 400, Vn = 400, r = 0.0, x = 0.1) annotation(
    Placement(visible = true, transformation(origin = {-42, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker1(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {-10, 8}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker2(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {38, 8}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker3(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {-10, -8}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Events.Breaker breaker4(rc_enabled = true) annotation(
    Placement(visible = true, transformation(origin = {38, -8}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0, X = 0.4) annotation(
    Placement(visible = true, transformation(origin = {12, 8}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0, G = 0, R = 0, X = 0.4) annotation(
    Placement(visible = true, transformation(origin = {12, -8}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  constant Real pi = 2 * Modelica.Math.asin(1.0);
  constant Real D2R = pi / 180 "Degree to Radian";
  constant Real R2D = 180 / pi "Radian to Degree";
  parameter Real delta(final unit = "deg") = 28.44 "rotor angle in degrees";
  //also refer Ex14_3;
  parameter Real Ws(final unit = "rad/s") = 377 "synchronous speed";
  inner OpenIPSL.Electrical.SystemBase SysData(S_b = 100, fn = 50) annotation(
    Placement(visible = true, transformation(origin = {-86, 88}, extent = {{-12, -10}, {12, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus3(displayPF = true)  annotation(
    Placement(visible = true, transformation(origin = {-64, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  connect(bus3.p, generator1.p) annotation(
    Line(points = {{-64, 0}, {-72, 0}, {-72, 0}, {-72, 0}}, color = {0, 0, 255}));
  connect(bus3.p, twoWindingTransformer1.p) annotation(
    Line(points = {{-64, 0}, {-54, 0}, {-54, 0}, {-52, 0}}, color = {0, 0, 255}));
  connect(twoWindingTransformer1.n, bus1.p) annotation(
    Line(points = {{-31, 0}, {-22, 0}}, color = {0, 0, 255}));
  connect(breaker1.s, bus1.p) annotation(
    Line(points = {{-15, 8}, {-22, 8}, {-22, 0}}, color = {0, 0, 255}));
  connect(breaker3.s, bus1.p) annotation(
    Line(points = {{-15, -8}, {-22, -8}, {-22, 0}}, color = {0, 0, 255}));
  connect(breaker1.r, pwLine2.p) annotation(
    Line(points = {{-5, 8}, {3, 8}}, color = {0, 0, 255}));
  connect(breaker3.r, pwLine3.p) annotation(
    Line(points = {{-5, -8}, {3, -8}}, color = {0, 0, 255}));
  connect(pwLine3.n, breaker4.s) annotation(
    Line(points = {{21, -8}, {33, -8}}, color = {0, 0, 255}));
  connect(pwLine2.n, breaker2.s) annotation(
    Line(points = {{21, 8}, {33, 8}}, color = {0, 0, 255}));
  connect(breaker2.r, bus2.p) annotation(
    Line(points = {{43, 8}, {52, 8}, {52, 0}}, color = {0, 0, 255}));
  connect(breaker4.r, bus2.p) annotation(
    Line(points = {{43, -8}, {52, -8}, {52, 0}}, color = {0, 0, 255}));
  connect(bus2.p, infiniteBus1.p) annotation(
    Line(points = {{52, 0}, {94, 0}}, color = {0, 0, 255}));
  Sp = 2.10 * cos(delta * D2R) "refer Ex_14_3";
  Wn = sqrt(Ws * Sp / generator1.M);
  fn = Wn / (2 * pi);
  T = 1 / fn;
  connect(generator1.pm0, generator1.pm) annotation(
    Line(points = {{-90, -12}, {-90, -12}, {-90, -22}, {-98, -22}, {-98, -4}, {-94, -4}, {-94, -6}}, color = {0, 0, 127}));
  connect(generator1.vf0, generator1.vf) annotation(
    Line(points = {{-90, 12}, {-90, 12}, {-90, 20}, {-98, 20}, {-98, 4}, {-94, 4}, {-94, 6}}, color = {0, 0, 127}));
//"The  answer may slightly vary due to  rounding off values"
  annotation(
    Diagram,
    Icon,
    __OpenModelica_commandLineOptions = "");

end Ex14_6;
