model Ex14_8

//refer Ex_14_3; Ex_14_4; Ex_14_5
  
  Modelica.SIunits.Angle d_crit "critical clearing angle";

  constant Real pi=2*Modelica.Math.asin(1.0);
  constant Real D2R=pi/180 "Degree to Radian";
  constant Real R2D=180/pi "Radian to Degree";
  parameter Real delta (final unit= "deg")= 28.44 "rotor angle";
  parameter Real delta_rad (final unit= "rad")= delta * D2R "initial rotor angle in radian";
  parameter Real Pe (final unit= "per unit")= 2.10 * sin(delta_rad) "electrical power";
  parameter Real Pe1 (final unit= "per unit")= 0.808*sin(delta_rad) "power-angle equation during fault";
  parameter Real Pe2 (final unit= "per unit")= 1.5*sin(delta_rad) "power-angle equation after fault";
  parameter Real r1= Pe1/Pe;
  parameter Real r2= Pe2/Pe;
  parameter Real dmax (final unit= "rad")= pi-asin(1/1.5) "max rotor angle";
  
equation
  d_crit= acos((((1/2.10)*(dmax-delta_rad))+(r2*cos(dmax))-(r1*cos(delta_rad)))/(r2-r1));
 
//"The  answer may slightly vary due to  rounding off values" 

end Ex14_8;
