model Ex2_2

  Modelica.SIunits.ComplexVoltage Vbc "phase voltage";
  Modelica.SIunits.ComplexVoltage Vca "phase voltage";
  Modelica.SIunits.ComplexVoltage Van "line to neutral voltage";
  Modelica.SIunits.ComplexVoltage Vbn "line to neutral voltage";
  Modelica.SIunits.ComplexVoltage Vcn "line to neutral voltage";
  Modelica.SIunits.ComplexCurrent Ian "line to neutral current";
  Modelica.SIunits.ComplexCurrent Ibn "line to neutral current";
  Modelica.SIunits.ComplexCurrent Icn "line to neutral current";
  Modelica.SIunits.Voltage abs_Vbc "magnitude of Vbc";
  Modelica.SIunits.Angle arg_Vbc "argument of Vbc";
  Modelica.SIunits.Voltage abs_Vca "magnitude of Vca";
  Modelica.SIunits.Angle arg_Vca "argument of Vca";
  Modelica.SIunits.Voltage abs_Van "magnitude of Van";
  Modelica.SIunits.Angle arg_Van "argument of Van";
  Modelica.SIunits.Voltage abs_Vbn "magnitude of Vbn";
  Modelica.SIunits.Angle arg_Vbn "argument of Vbn";
  Modelica.SIunits.Voltage abs_Vcn "magnitude of Vcn";
  Modelica.SIunits.Angle arg_Vcn "argument of Vcn";
  Modelica.SIunits.Current abs_Ian "magnitude of Ian";
  Modelica.SIunits.Angle arg_Ian "argument of Ian";
  Modelica.SIunits.Current abs_Ibn "magnitude of Ibn";
  Modelica.SIunits.Angle arg_Ibn "argument of Ibn";
  Modelica.SIunits.Current abs_Icn "magnitude of Icn";
  Modelica.SIunits.Angle arg_Icn "argument of Icn";
  
  constant Real pi=2*Modelica.Math.asin(1.0);
  constant Real D2R=pi/180 "Degree to Radian";
  constant Real R2D=180/pi "Radian to Degree";
  parameter Real abs_Vab= 173.2 "phase voltage magnitude";
  parameter Modelica.SIunits.Angle arg_Vab= 0 "phase voltage angle";
  parameter Real abs_Zl= 10 "load impedance magnitude";
  parameter Real arg_Zl (final unit="deg")= 20 "load impedance angle";
  parameter Complex Vab= Complex(re= abs_Vab*cos(arg_Vab), im= abs_Vab*sin(arg_Vab)) "phase voltage";
  parameter Real V_b= 100 "line to neutral voltage";
  parameter Complex Zl= Complex(abs_Zl*cos((arg_Zl)*D2R), abs_Zl*sin((arg_Zl)*D2R)) "load impedance";
  
  
equation
 
  Vbc= Complex(abs_Vab*cos((arg_Vab+240)*D2R), abs_Vab*sin((arg_Vab+240)*D2R));
  Vca= Complex(abs_Vab*cos((arg_Vab+120)*D2R), abs_Vab*sin((arg_Vab+120)*D2R));
  abs_Vbc= sqrt(((Vbc.re)^(2))+((Vbc.im)^(2)));
  arg_Vbc= (atan(Vbc.im/Vbc.re))+pi;
  abs_Vca= sqrt(((Vca.re)^(2))+((Vca.im)^(2)));
  arg_Vca= (atan(Vca.im/Vca.re))+pi;
  
  Van= Complex(V_b*cos((-30)*D2R), V_b*sin((-30*D2R)));
  abs_Van= sqrt(((Van.re)^(2))+((Van.im)^(2)));
  arg_Van= (atan(Van.im/Van.re));
  Vbn= Complex(V_b*cos((arg_Van+(4*pi/3))), V_b*sin((arg_Van+(4*pi/3))));
  Vcn= Complex(V_b*cos((arg_Van+(2*pi/3))), V_b*sin((arg_Van+(2*pi/3))));
  
  abs_Vbn= sqrt(((Vbn.re)^(2))+((Vbn.im)^(2)));
  arg_Vbn= (atan(Vbn.im/Vbn.re))+pi;
  
  abs_Vcn= sqrt(((Vcn.re)^(2))+((Vcn.im)^(2)));
  arg_Vcn= (atan(Vcn.im/Vcn.re));
  Ian= Van/Zl;
  abs_Ian= sqrt(((Ian.re)^(2))+((Ian.im)^(2)));
  arg_Ian= (atan(Ian.im/Ian.re));
  Ibn= Vbn/Zl;
  abs_Ibn= sqrt(((Ibn.re)^(2))+((Ibn.im)^(2)));
  arg_Ibn= (atan(Ibn.im/Ibn.re))+pi;
  Icn= Vcn/Zl;
  abs_Icn= sqrt(((Icn.re)^(2))+((Icn.im)^(2)));
  arg_Icn= (atan(Icn.im/Icn.re));
  
//"The  answer may slightly vary due to  rounding off values" 

end Ex2_2;
