model EX2_3
OpenIPSL.Types.VoltageKilo Vbus "magnitude of  voltage at substation bus";
  Modelica.SIunits.ComplexCurrent Ian "Current across load";
  Modelica.SIunits.ComplexVoltage Vln "line to neutral voltage";
  Modelica.SIunits.Voltage Vln_abs "magnitude of Vln";
  Modelica.SIunits.Angle Vln_arg "argument of Vln";
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance1(Z_ref(re = 0.36, im = 1.35)) annotation(
    Placement(visible = true, transformation(origin = {-32, 22}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance2(Z_ref(re = 17.32, im = 10)) annotation(
    Placement(visible = true, transformation(origin = {20, -8}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Sources.VoltageSource voltageSource1(V = 2670, f = 50, phi = 0.0471239) annotation(
    Placement(visible = true, transformation(origin = {-80, -6}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Sources.VoltageSource voltageSource2(V = 4400/sqrt(3), f = 50, phi = 0) annotation(
    Placement(visible = true, transformation(origin = {74, -8}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Ground ground1 annotation(
    Placement(visible = true, transformation(origin = {-80, -60}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Ground ground2 annotation(
    Placement(visible = true, transformation(origin = {20, -58}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Ground ground3 annotation(
    Placement(visible = true, transformation(origin = {74, -58}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  Ian= voltageSource2.v/impedance2.Z_ref;
  Vln= voltageSource2.v+(Ian*impedance1.Z_ref);
  Vln_abs= sqrt(Vln.re^2+Vln.im^2);
  Vln_arg= atan(Vln.im/Vln.re);
  Vbus = sqrt(3) * (Vln_abs * 1e-3);
  connect(voltageSource2.pin_p, impedance2.pin_p) annotation(
    Line(points = {{74, 2}, {74, 2}, {74, 22}, {20, 22}, {20, 2}, {20, 2}}, color = {85, 170, 255}));
  connect(voltageSource2.pin_n, ground3.pin) annotation(
    Line(points = {{74, -18}, {74, -48}}, color = {85, 170, 255}));
  connect(impedance2.pin_n, ground2.pin) annotation(
    Line(points = {{20, -18}, {20, -18}, {20, -48}, {20, -48}}, color = {85, 170, 255}));
  connect(voltageSource1.pin_n, ground1.pin) annotation(
    Line(points = {{-80, -16}, {-80, -16}, {-80, -50}, {-80, -50}}, color = {85, 170, 255}));
  connect(voltageSource1.pin_p, impedance1.pin_p) annotation(
    Line(points = {{-80, 4}, {-80, 22}, {-42, 22}}, color = {85, 170, 255}));
  connect(impedance1.pin_n, impedance2.pin_p) annotation(
    Line(points = {{-22, 22}, {18, 22}, {18, 22}, {20, 22}, {20, 2}, {20, 2}}, color = {85, 170, 255}));
 
//"The  answer may slightly vary due to  rounding off values" 
end EX2_3;
