model Ex4_1
Real r (final unit="ft") "radius of the conductor";
  Real Xc (final unit="ohm.mi to neutral") "capacitive reactance";
  Real Bc (final unit="mho/mi to neutral") "capacitive susceptance";
  Real Xc1 (final unit="ohm.mi per conductor") "capacitive reactance in terms of 1-ft spacing";
  Real Xc2 (final unit="ohm.mi") "line to line capacitive reactance";
  Real Bc1 (final unit="mho/mi") "line to line capacitive susceptance";
  parameter Real Ds (final unit="ft")= 0.642 "GMR of the conductor";
  parameter Real d (final unit="ft")= 20 "spacing between the centers of the Patridge conductor";
  parameter Modelica.SIunits.Frequency f= 60;
  parameter Real Xa (final unit="ohm.mi")= 0.1074e6 "capacitive reactance obtained from table A.1";
  parameter Real Xd (final unit="ohm.mi")= 0.0889e6 "capacitive reactance obtained from table A.1";
  
equation  
  r= Ds/(2*12);
  Xc= (1779000/f)*(log(d/r));
  Bc=1/Xc;
  Xc1= (Xa+Xd);
  Xc2= 2*Xc1;
  Bc1= 1/Xc2;
   
//"The  answer may slightly vary due to  rounding off values" 

end Ex4_1;
