model Ex4_3
Modelica.SIunits.Length r "radius of the conductor";
  Modelica.SIunits.Length Dbsc "modified GMR of the conductors";
  Real Cm (final unit="F/m") "capacitance to neutral";
  Real Xc (final unit="ohm.km per phase to neutral") "capacitive reactance to neutral of line";
  Real Xc1 (final unit="ohm.mi per phase to neutral") "capacitive reactance to neutral of line in miles";
  
  constant Real pi=2*Modelica.Math.asin(1.0);
  parameter Real Ds (final unit="ft")= 1.382 "GMR of the conductor";
  parameter Modelica.SIunits.Length l= 0.45 "spacing between bundled conductors";
  parameter Modelica.SIunits.Length Deq= 10.08 "Geometric mean of three conductors";
  parameter Modelica.SIunits.Frequency f= 60 "frequency";
  
equation
   r= (Ds*0.3048)/(2*12);
   Dbsc= (r*l)^(1/2);
   Cm= (2*pi*8.85e-12)/(log(Deq/Dbsc));
   Xc= 1/(2*pi*f*Cm*1000);
   Xc1= Xc/1.609;
   
//"The  answer may slightly vary due to  rounding off values" 
end Ex4_3;
