model Ex5_3

  Real Deq (final unit= "ft") "Geometric mean of the conductor";
  Complex Z "series impedance per unit length per phase";
  Complex Y "shunt admittance per unit length per phase";
  Complex gama_l "total propagation constant";
  Complex P "generalized circuit constant";
  Complex Q "generalized circuit constant";
  Modelica.SIunits.ComplexImpedance Zc  "characteristic impedance of line";
  Modelica.SIunits.ComplexImpedance Zc_1 "equivalent-pi circuit characteristic impedance of line";
  Complex Y_1 "equivalent-pi circuit characteristic admittance of line";
  Modelica.SIunits.ComplexImpedance Z_1 "nominal-pi circuit characteristic impedance of line";
  Complex Y_2 "nominal-pi circuit characteristic admittance of line";
  Real abs_Z (final unit= "ohm/mi") "magnitude of Z";
  Modelica.SIunits.Angle arg_Z "argument of Z";
  Real abs_Y (final unit= "mho/mi") "magnitude of Y";
  Modelica.SIunits.Angle arg_Y "argument of Y";
  Real abs_gama_l "magnitude of gama_l";
  Modelica.SIunits.Angle arg_gama_l "argument of gama_l";
  Modelica.SIunits.Impedance abs_Zc "magnitude of Zc";
  Modelica.SIunits.Angle arg_Zc "argument of Zc";
  Real abs_P "magnitude of P";
  Modelica.SIunits.Angle arg_P "argument of P";
  Real abs_Q "magnitude of Q";
  Modelica.SIunits.Angle arg_Q "argument of Q";
  Modelica.SIunits.Impedance abs_Zc_1 "magnitude of Zc_1";
  Modelica.SIunits.Angle arg_Zc_1 "argument of Zc_1";
  Real abs_Y_1 (final unit= "mho") "magnitude of Y_1";
  Modelica.SIunits.Angle arg_Y_1 "argument of Y_1";
  Modelica.SIunits.Impedance abs_Z_1 "magnitude of Z_2";
  Modelica.SIunits.Angle arg_Z_1 "argument of Z_2";
  Real abs_Y_2 (final unit= "mho") "magnitude of Y_2";
  Modelica.SIunits.Angle arg_Y_2 "argument of Y_2";
  
  constant Real pi=2*Modelica.Math.asin(1.0);
  constant Real D2R=pi/180 "Degree to Radian";
  constant Real R2D=180/pi "Radian to Degree";
  parameter Real C1 (final unit="ohm/mi")= 0.415 "inductive reactance obtained for rook conductor";
  parameter Real C2 (final unit="ohm/mi")= 0.4127 "inductive reactance spacing obtained for rook conductor";
  parameter Real a1 (final unit= "Mohm.mi")= 0.0950e6 "capacitive reactance obtained for rook conductor";
  parameter Real a2 (final unit= "Mohm.mi")= 0.1009e6 "capacitive reactance spacing obtained for rook conductor";
  parameter Real l (final unit= "mi")= 230 "lenghth of transmission lines";
  parameter Real Dbc (final unit= "ft")= 23.8 "Diameter of the conductor b and c";
  parameter Real Dab (final unit= "ft")= 23.8 "Diameter of the conductor a and b";
  parameter Real Dac (final unit= "ft")= 47.6 "Diameter of the conductor a and c";
  
equation
  Deq= (Dab*Dac*Dbc)^(1/3);
  Z= Complex(0.1603, C1+C2);
  abs_Z= sqrt(((0.1603)^(2))+((C1+C2)^(2)));
  arg_Z= (atan(Z.im/Z.re));
  Y= Complex(0, 1/(a1+a2));
  abs_Y= sqrt(Y.re^(2)+Y.im^(2));
  arg_Y= pi/2;
  abs_gama_l= l*((abs_Z*abs_Y)^(0.5));
  arg_gama_l= ((arg_Z+arg_Y)/(2));
  gama_l= Complex(abs_gama_l*cos(arg_gama_l), abs_gama_l*sin(arg_gama_l));
  abs_Zc= sqrt(abs_Z/abs_Y);
  arg_Zc= ((arg_Z-arg_Y)/(2));
  Zc= Complex(abs_Zc*cos(arg_Zc), abs_Zc*sin(arg_Zc));
  P= Complex(cosh(gama_l.re)*cos(gama_l.im), sinh(gama_l.re)*sin(gama_l.im));
  abs_P= sqrt(((P.re)^(2))+((P.im)^(2)));
  arg_P= (atan(P.im/P.re));
  Q= Complex(sinh(gama_l.re)*cos(gama_l.im), cosh(gama_l.re)*sin(gama_l.im));
  abs_Q= sqrt(((Q.re)^(2))+((Q.im)^(2)));
  arg_Q= (atan(Q.im/Q.re));
  Zc_1= Zc*Q;
  abs_Zc_1= sqrt(((Zc_1.re)^(2))+((Zc_1.im)^(2)));
  arg_Zc_1= (atan(Zc_1.im/Zc_1.re));
  Y_1= (P-1)/Zc_1;
  abs_Y_1= sqrt(((Y_1.re)^(2))+((Y_1.im)^(2)));
  arg_Y_1= (atan(Y_1.im/Y_1.re));
  Z_1= l*(Z);
  abs_Z_1= sqrt(((Z_1.re)^(2))+((Z_1.im)^(2)));
  arg_Z_1= (atan(Z_1.im/Z_1.re));
  Y_2= (Y/2)*l;
  abs_Y_2= sqrt(((Y_2.re)^(2))+((Y_2.im)^(2)));
  arg_Y_2= arg_Y;
   
//"The  answer may slightly vary due to  rounding off values" 

end Ex5_3;
