model Ex6_3

  Modelica.SIunits.Current I1 "current at primary";
  Modelica.SIunits.Current I2 "current at secondary";
  Modelica.SIunits.Voltage V2 "voltage at secondary of auto transformer";
  Modelica.SIunits.Current Iin "input current";
  Modelica.SIunits.ApparentPower Pin "input KVA rating of auto transformer";
  Modelica.SIunits.ApparentPower Pout "output KVA rating of auto transformer";
  
  parameter Modelica.SIunits.ApparentPower P_b= 30e3 "power rating of single phase transformer";
  parameter Modelica.SIunits.Voltage Vp= 240 "voltage at primary of single phase transformer";
  parameter Modelica.SIunits.Voltage Vs= 120 "voltage at secondary of single phase transformer";
  
equation  
  I1= P_b/Vs;
  I2= P_b/Vp;
  V2= Vp+Vs;
  Iin= I1+I2;
  Pin= Iin*Vs;
  Pout= I2*V2;
 
//"The  answer may slightly vary due to  rounding off values" 

end Ex6_3;
