model Ex6_5

  OpenIPSL.Types.VoltageKilo Vb_A "Base voltage of circuit A";
  OpenIPSL.Types.VoltageKilo Vb_C "Base voltage of circuit C";
  Modelica.SIunits.Impedance Zb_C "Base impedance of circuit C";
  Real Zb_C_pu (final unit= "per unit") "Base impedance of circuit C in per unit";
  Modelica.SIunits.Impedance Zb_B "Base impedance of circuit B";
  Modelica.SIunits.Impedance Zb_B_load "impedance of load refered to circuit B";
  Real Zb_B_load_pu (final unit= "per unit") "impedance of load refered to circuit B in per unit";
  Modelica.SIunits.Impedance Zb_A "Base impedance of circuit A";
  Modelica.SIunits.Impedance Zb_A_load "impedance of load refered to circuit A in per unit";
  Real Zb_A_load_pu (final unit= "per unit") "impedance of load refered to circuit A in per unit";
  Real V_load_pu (final unit= "per unit") "voltage at load";
  Complex I_load "load current";
  Complex Vin "input voltage";
  Real abs_Vin (final unit= "per unit") "magnitude of Vin";
  Real V_regu "voltage regulation";
  
  parameter OpenIPSL.Types.VoltageKilo Vp_AB=138 "primary voltage at circuit A-B";
  parameter OpenIPSL.Types.VoltageKilo Vs_AB= 13.8 "seconadry voltage at circuit A-B";
  parameter OpenIPSL.Types.VoltageKilo Vp_BC= 138 "primary voltage at circuit B-C";
  parameter OpenIPSL.Types.VoltageKilo Vs_BC= 69 "seconadry voltage at circuit B-c";
  parameter Real Tab= (Vs_AB/Vp_AB) "turns ratio";
  parameter Real Tbc= Vs_BC/Vp_BC "turns ratio";
  parameter OpenIPSL.Types.ApparentPowerMega Pb= 10 "base power";
  parameter Modelica.SIunits.Impedance Zl= 300 "load impedance";
  parameter OpenIPSL.Types.VoltageKilo Vb= 66 "base voltage";
  parameter Complex Xab_leakage= Complex(0, 0.10) "leakage reactance of circuit A-B";
  parameter Complex Xbc_leakage= Complex(0, 0.08) "leakage reactance of circuit B-C";
  
equation
  Vb_A= Tab*Vp_AB;
  Vb_C= Tbc*Vp_AB;
  Zb_C= ((Vp_BC^2)*1000)/10000;
  Zb_C_pu= Zl/Zb_C;
  Zb_B= ((Vp_AB^2)*1000)/10000;
  Zb_B_load= Zl*(2^2);
  Zb_B_load_pu= Zb_B_load/Zb_B;
  Zb_A= (Vs_AB^2*1000)/10000 ;
  Zb_A_load= Zl*(2^2)*(0.1^2);
  Zb_A_load_pu= Zb_A_load/Zb_A;
  V_load_pu= Vb/Vb_C;
  I_load= Complex( V_load_pu/Zb_B_load_pu, 0);
  Vin= I_load*(Xab_leakage+Xbc_leakage)+V_load_pu;
  abs_Vin= sqrt(Vin.re ^ 2 + Vin.im ^ 2);
  V_regu= ((abs_Vin-V_load_pu)/V_load_pu)*100;
    
//"The  answer may slightly vary due to  rounding off values" 

end Ex6_5;
