model Ex7_3

  //refer Ex_7_1 & Ex_7_2
  Complex [2,2]M_inv "inverse of matrix M";
  Complex [2,2]Ybus "admittance of bus";
  Complex Ybus_ref "admittance w.r.t reference bus";
  Complex I "total current";
  Complex I_conj "conjugate of I";
  Complex Pa "power at source a";
  Complex Pb "power at source b";
  Complex V1 "voltage at node 1";
  
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance1(Z_ref(re=0, im=1.25))  annotation(
    Placement(visible = true, transformation(origin = {-46, 70}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance2(Z_ref(re= 0, im=1.25))  annotation(
    Placement(visible = true, transformation(origin = {-46, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance3(Z_ref(re= 0, im= 1.25))  annotation(
    Placement(visible = true, transformation(origin = {-46, -72}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance4(Z_ref(re= 0, im= 0.25))  annotation(
    Placement(visible = true, transformation(origin = {-8, 32}, extent = {{10, -10}, {-10, 10}}, rotation = 90)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance5(Z_ref(re= 0, im= 0.4))  annotation(
    Placement(visible = true, transformation(origin = {-8, -36}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance6(Z_ref(re= 0, im= 0.125))  annotation(
    Placement(visible = true, transformation(origin = {28, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance7(Z_ref(re= 0, im= 0.2))  annotation(
    Placement(visible = true, transformation(origin = {40, 60}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Impedance impedance8(Z_ref(re= 0, im= 0.2))  annotation(
    Placement(visible = true, transformation(origin = {40, -60}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Basic.Ground ground1 annotation(
    Placement(visible = true, transformation(origin = {90, -92}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Sources.VoltageSource Ea(V = 1.5, f = 50, phi = 0)  annotation(
    Placement(visible = true, transformation(origin = {-80, 70}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Sources.VoltageSource Eb(V = 1.5, f = 50, phi = -0.643503)  annotation(
    Placement(visible = true, transformation(origin = {-80, -72}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  Modelica.Electrical.QuasiStationary.SinglePhase.Sources.VoltageSource Ec(V = 1.5, f = 50, phi = 0)  annotation(
    Placement(visible = true, transformation(origin = {-78, 0}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  
  parameter Complex [2,2]K= {{Complex(0,-9.8),Complex(0,0)},{Complex(0,0),Complex(0,-8.3)}};
  parameter Complex [2,2]L= {{Complex(0,4),Complex(0,5)},{Complex(0,2.5),Complex(0,5)}};
  parameter Complex [2,2]L_t= transpose(L);
  Complex [2,2]M={{Complex(0,-14.5), Complex(0,8)},{Complex(0,8), Complex(0,-18)}};
equation
  connect(Eb.pin_p, impedance3.pin_p) annotation(
    Line(points = {{-70, -72}, {-56, -72}}, color = {85, 170, 255}));
  connect(Eb.pin_n, ground1.pin) annotation(
    Line(points = {{-90, -72}, {-96, -72}, {-96, -82}, {90, -82}}, color = {85, 170, 255}));
  connect(Ec.pin_p, impedance2.pin_p) annotation(
    Line(points = {{-68, 0}, {-56, 0}}, color = {85, 170, 255}));
  connect(Ec.pin_n, ground1.pin) annotation(
    Line(points = {{-88, 0}, {-96, 0}, {-96, -82}, {90, -82}}, color = {85, 170, 255}));

  M_inv= Complex(0,-Modelica.Math.Matrices.inv(M.im));
  Ybus= Complex(0,(K.im)-(-L.im*M_inv.im*L_t.im));
  Ybus_ref= Ybus[1,2]-Ybus[2,2];
  I= (Complex(Ea.abs_v*cos(Ea.arg_v),Ea.abs_v*sin(Ea.arg_v))-Complex(Eb.abs_v*cos(Eb.arg_v),Eb.abs_v*sin(Eb.arg_v)))/Complex(0,(1.25+1.25+0.2455));
  I_conj= Complex(I.re,-I.im);
  Pa= Complex(Ea.abs_v*cos(Ea.arg_v),Ea.abs_v*sin(Ea.arg_v))*I_conj;
  Pb= Complex(Eb.abs_v*cos(Eb.arg_v),Eb.abs_v*sin(Eb.arg_v))*I_conj;
  V1= Ea.abs_v-Complex(0,1.25)*I;
  
  connect(impedance7.pin_n, ground1.pin) annotation(
    Line(points = {{50, 60}, {90, 60}, {90, 0}, {90, 0}, {90, -82}, {90, -82}}, color = {85, 170, 255}));
  connect(impedance6.pin_n, ground1.pin) annotation(
    Line(points = {{38, 0}, {90, 0}, {90, -82}}, color = {85, 170, 255}));
  connect(impedance8.pin_n, ground1.pin) annotation(
    Line(points = {{50, -60}, {90, -60}, {90, -82}, {90, -82}, {90, -82}}, color = {85, 170, 255}));
  connect(Ea.pin_n, ground1.pin) annotation(
    Line(points = {{-90, 70}, {-96, 70}, {-96, -82}, {90, -82}, {90, -82}}, color = {85, 170, 255}));
  connect(impedance8.pin_p, impedance3.pin_n) annotation(
    Line(points = {{30, -60}, {-8, -60}, {-8, -72}, {-36, -72}, {-36, -72}}, color = {85, 170, 255}));
  connect(impedance1.pin_n, impedance7.pin_p) annotation(
    Line(points = {{-36, 70}, {-8, 70}, {-8, 60}, {30, 60}, {30, 60}}, color = {85, 170, 255}));
  connect(impedance5.pin_n, impedance3.pin_n) annotation(
    Line(points = {{-8, -46}, {-8, -46}, {-8, -72}, {-36, -72}, {-36, -72}}, color = {85, 170, 255}));
  connect(impedance5.pin_p, impedance2.pin_n) annotation(
    Line(points = {{-8, -26}, {-8, 0}, {-36, 0}}, color = {85, 170, 255}));
  connect(impedance2.pin_n, impedance6.pin_p) annotation(
    Line(points = {{-36, 0}, {16, 0}, {16, 0}, {18, 0}}, color = {85, 170, 255}));
  connect(impedance4.pin_n, impedance2.pin_n) annotation(
    Line(points = {{-8, 22}, {-8, 22}, {-8, 0}, {-36, 0}, {-36, 0}}, color = {85, 170, 255}));
  connect(impedance1.pin_n, impedance4.pin_p) annotation(
    Line(points = {{-36, 70}, {-8, 70}, {-8, 42}, {-8, 42}}, color = {85, 170, 255}));
  connect(Ea.pin_p, impedance1.pin_p) annotation(
    Line(points = {{-70, 70}, {-56, 70}}, color = {85, 170, 255}));
 
//"The  answer may slightly vary due to  rounding off values" 

end Ex7_3;
