model Ex7_6

  Complex V1 "voltage at node 1 with all emfs shorted";
  Complex V2 "voltage at node 2 with all emfs shorted";
  Complex V3 "voltage at node 3 with all emfs shorted";
  Complex V4 "voltage at node 4 with all emfs shorted";
  Real V1_abs (final unit= "per unit") "magnitude of V1";
  Real V2_abs (final unit= "per unit") "magnitude of V2";
  Real V3_abs (final unit= "per unit") "magnitude of V3";
  Real V4_abs (final unit= "per unit") "magnitude of V4";
  Modelica.SIunits.Angle V1_arg "argument of V1";
  Modelica.SIunits.Angle V2_arg "argument of V2";
  Modelica.SIunits.Angle V3_arg "argument of V3";
  Modelica.SIunits.Angle V4_arg "argument of V4";
  Complex V1_final "final voltage of node 1 after injection of current at node 4(pu) after superposing the voltage obtained from Ex_7_2";
  Complex V2_final "final voltage of node 2 after injection of current at node 4(pu) after superposing the voltage obtained from Ex_7_2";
  Complex V3_final "final voltage of node 3 after injection of current at node 4(pu) after superposing the voltage obtained from Ex_7_2";
  Complex V4_final "final voltage of node 4 after injection of current at node 4(pu) after superposing the voltage obtained from Ex_7_2";
  Real V1_final_abs (final unit= "per unit") "magnitude of V1_final";
  Real V2_final_abs (final unit= "per unit") "magnitude of V2_final";
  Real V3_final_abs (final unit= "per unit") "magnitude of V3_final";
  Real V4_final_abs (final unit= "per unit") "magnitude of V4_final";
  Modelica.SIunits.Angle V1_final_arg "argument of V1_final";
  Modelica.SIunits.Angle V2_final_arg "argument of V2_final";
  Modelica.SIunits.Angle V3_final_arg "argument of V3_final";
  Modelica.SIunits.Angle V4_final_arg "argument of V4_final";
  
  constant Real pi=2*Modelica.Math.asin(1.0);
  constant Real D2R=pi/180 "Degree to Radian";
  constant Real R2D=180/pi "Radian to Degree";
  parameter Complex I4= Complex(-0.316*cos(78.03*D2R), -0.316*sin(78.03*D2R))"current injected on node 4(pu)";
  parameter Complex [4,4]Zbus= {{Complex(0,0.4774),Complex(0,0.3706),Complex(0,0.4020),Complex(0,0.4142)},{Complex(0,0.3706),Complex(0,0.4872),Complex(0,0.3922),Complex(0,0.4126)},{Complex(0,0.4020),Complex(0,0.3922),Complex(0,0.4558),Complex(0,0.4232)},{Complex(0,0.4142),Complex(0,0.4126),Complex(0,0.4232),Complex(0,0.4733)}} "bus impedance matrix";
  
equation
  V1= I4*Zbus[1,4];
  V2= I4*Zbus[2,4];
  V3= I4*Zbus[3,4];
  V4= I4*Zbus[4,4];
  V1_abs= sqrt(V1.re^2+V1.im^2);
  V2_abs= sqrt(V2.re^2+V2.im^2);
  V3_abs= sqrt(V3.re^2+V3.im^2);
  V4_abs= sqrt(V4.re^2+V4.im^2);
  V4_arg= atan(V4.im/V4.re);
  V1_arg= atan(V1.im/V1.re);
  V2_arg= atan(V2.im/V2.re);
  V3_arg= atan(V3.im/V3.re);
  
  V1_final= V1+Complex(1.4111, -0.2668);
  V2_final= V2+Complex(1.3830, -0.3508);
  V3_final= V3+Complex(1.4059, -0.2824);
  V4_final= V4+Complex(1.4009, -0.2971);
  V1_final_abs= sqrt(V1_final.re^2+V1_final.im^2);
  V2_final_abs= sqrt(V2_final.re^2+V2_final.im^2);
  V3_final_abs= sqrt(V3_final.re^2+V3_final.im^2);
  V4_final_abs= sqrt(V4_final.re^2+V4_final.im^2);
  V4_final_arg= atan(V4_final.im/V4_final.re);
  V1_final_arg= atan(V1_final.im/V1_final.re);
  V2_final_arg= atan(V2_final.im/V2_final.re);
  V3_final_arg= atan(V3_final.im/V3_final.re);
   
//"The  answer may slightly vary due to  rounding off values" 

end Ex7_6;
