model Ex8_3

  Complex I2 "Current across Z in pu";
  Complex Y21_tra "node 1 admittance for transformer a alone(pu)";
  Complex Y22_tra "node 2 admittance for transformer a alone(pu)";
  Complex Y21_trb "node 1 admittance for transformer b alone(pu)";
  Complex Y22_trb "node 2 admittance for transformer b alone(pu)";
  Complex Y21 "node 1 admittance for transformer a & b in parallel(pu)";
  Complex Y22 "node 2 admittance for transformer a & b in parallel(pu)";
  Complex V1 "voltage L-T side (pu)";
  Complex Ita "current across transformer a(pu)";
  Complex Itb "current in transformer b (pu)";
  Complex Sta "total power in transformer a(pu)";
  Complex Stb "total power in transformer a(pu)";
  
  parameter Complex Z= Complex(0.8, 0.6) "impedance in pu";
  parameter Real V2 (final unit= "per unit")= 1.0 "voltage across impedance Z(pu)";
  parameter Real a= 1.05 "tap windings";
  parameter Complex Za= Complex(0, 0.1) "impedance of transformer a(pu)";
  parameter Complex Zb= Complex(0, 0.1) "impedance of transformer b(pu)";
  
equation
  I2= -(V2)/(Z);
  Y21_tra= -1/Za;
  Y22_tra= 1/Za;
  Y21_trb= -(1/Zb)/a;
  Y22_trb= (1/Zb)/(a^2);
  Y21= Y21_tra+Y21_trb;
  Y22= Y22_tra+Y22_trb;
  V1= (I2-(Y22*V2))/Y21;
  Ita= (V1-V2)*Y22_tra;
  Itb= -I2-Ita;
  Sta= V2*(Complex(Ita.re, -Ita.im));
  Stb= (Complex(Itb.re, -Itb.im))*V2;
 
//"The  answer may slightly vary due to  rounding off values" 

end Ex8_3;
