model Ex9_3
Complex V1 "voltage at unit 1(pu)";
  Complex V2 "voltage at unit 2(pu)";
  Real B11 (final unit= "per unit") "loss coefficients";
  Real B12 (final unit= "per unit") "loss coefficients";
  Real B22 (final unit= "per unit") "loss coefficients";
  OpenIPSL.Electrical.Buses.Bus bus1( V_b = 100, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {-54, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2(V_0 =1, V_b = 100, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {54, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus3(V_0 = 1, V_b = 100, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {2, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus4(V_0 = 1, V_b = 100, displayPF = true) annotation(
    Placement(visible = true, transformation(origin = {10, -46}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Branches.PwLine pwLine1(B = 0, G = 0, R = 0.04, X = 0.16) annotation(
    Placement(visible = true, transformation(origin = {-30, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2(B = 0, G = 0, R = 0.03, X = 0.12) annotation(
    Placement(visible = true, transformation(origin = {26, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3(B = 0, G = 0, R = 0.02, X = 0.08) annotation(
    Placement(visible = true, transformation(origin = {10, -10}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator1(D = 0, M = 8, Sn = 100, V_b = 100, Vn = 100, ra = 0.001, x1d = 0.2) annotation(
    Placement(visible = true, transformation(origin = {-80, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Machines.PSAT.Order2 generator2(D = 0, M = 8, Sn = 100, V_b = 100, Vn = 100, ra = 0.001, x1d = 0.2) annotation(
    Placement(visible = true, transformation(origin = {78, 40}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Loads.PSAT.VoltDependant voltDependant1(V_0 = 1, V_b = 100) annotation(
    Placement(visible = true, transformation(origin = {10, -76}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  inner OpenIPSL.Electrical.SystemBase SysData(S_b = 100) annotation(
    Placement(visible = true, transformation(origin = {-72, 86}, extent = {{-12, -10}, {12, 10}}, rotation = 0)));
  parameter Complex I1 = Complex(1, 0) "current in bus 1";
  parameter Complex I2 = Complex(0.8, 0) "current in bus 2";
  parameter Real pf = 1 "since all are on same phase, hence pf=1";
  
equation
  V1 = bus3.V_0 + I1 * (Complex(pwLine1.R, pwLine1.X));
  V2 = bus3.V_0 + I2 *(Complex(pwLine2.R, pwLine2.X));
  B11 = (pwLine1.R + pwLine3.R) / (V1.re ^ 2 * pf ^ 2);
  B12 = pwLine3.R / (V1.re * V2.re * pf ^ 2);
  B22 = (pwLine2.R+ pwLine3.R) / (V2.re ^ 2 * pf ^ 2);
  connect(voltDependant1.p, bus4.p) annotation(
    Line(points = {{10, -66}, {10, -46}}, color = {0, 0, 255}));
  connect(bus2.p, generator2.p) annotation(
    Line(points = {{54, 40}, {68, 40}}, color = {0, 0, 255}));
  connect(pwLine2.n, bus2.p) annotation(
    Line(points = {{36, 40}, {54, 40}}, color = {0, 0, 255}));
  connect(generator2.pm, generator2.pm0) annotation(
    Line(points = {{90, 34}, {96, 34}, {96, 18}, {88, 18}, {88, 20}, {86, 20}, {86, 28}, {86, 28}}, color = {0, 0, 127}));
  connect(generator2.vf, generator2.vf0) annotation(
    Line(points = {{90, 46}, {98, 46}, {98, 68}, {86, 68}, {86, 52}, {86, 52}, {86, 52}}, color = {0, 0, 127}));
  connect(generator1.pm0, generator1.pm) annotation(
    Line(points = {{-88, 28}, {-88, 28}, {-88, 20}, {-98, 20}, {-98, 34}, {-92, 34}, {-92, 34}}, color = {0, 0, 127}));
  connect(generator1.vf0, generator1.vf) annotation(
    Line(points = {{-88, 52}, {-88, 52}, {-88, 66}, {-98, 66}, {-98, 44}, {-92, 44}, {-92, 46}}, color = {0, 0, 127}));
  connect(pwLine3.n, bus4.p) annotation(
    Line(points = {{10, -20}, {10, -20}, {10, -46}, {10, -46}}, color = {0, 0, 255}));
  connect(bus3.p, pwLine3.p) annotation(
    Line(points = {{2, 40}, {10, 40}, {10, 0}, {10, 0}}, color = {0, 0, 255}));
  connect(bus3.p, pwLine2.p) annotation(
    Line(points = {{2, 40}, {16, 40}, {16, 40}, {16, 40}}, color = {0, 0, 255}));
  connect(pwLine1.n, bus3.p) annotation(
    Line(points = {{-20, 40}, {2, 40}, {2, 40}, {2, 40}}, color = {0, 0, 255}));
  connect(bus1.p, pwLine1.p) annotation(
    Line(points = {{-54, 40}, {-40, 40}, {-40, 40}, {-40, 40}}, color = {0, 0, 255}));
  connect(generator1.p, bus1.p) annotation(
    Line(points = {{-70, 40}, {-54, 40}}, color = {0, 0, 255}));
//"The  answer may slightly vary due to  rounding off values"
end Ex9_3;
